% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Special.R
\docType{methods}
\name{Special}
\alias{Special}
\alias{beta,dual,dual-method}
\alias{beta,numeric,dual-method}
\alias{beta,dual,numeric-method}
\alias{lbeta,dual,dual-method}
\alias{lbeta,numeric,dual-method}
\alias{lbeta,dual,numeric-method}
\alias{gamma,dual-mehtod}
\alias{lgamma,dual-mehtod}
\alias{psigamma,dual,NULL-mehtod}
\alias{digamma,dual-mehtod}
\alias{trigamma,dual-mehtod}
\alias{choose,dual,dual-method}
\alias{choose,numeric,dual-method}
\alias{choose,dual,numeric-method}
\alias{lchoose,dual,dual-method}
\alias{lchoose,numeric,dual-method}
\alias{lchoose,dual,numeric-method}
\alias{factorial,dual-mehtod}
\alias{lfactorial,dual-mehtod}
\alias{gamma,dual-method}
\alias{lgamma,dual-method}
\alias{psigamma,dual-method}
\alias{digamma,dual-method}
\alias{trigamma,dual-method}
\alias{factorial,dual-method}
\alias{lfactorial,dual-method}
\title{Special Functions of Mathematics}
\usage{
\S4method{beta}{dual,dual}(a, b)

\S4method{beta}{dual,numeric}(a, b)

\S4method{beta}{numeric,dual}(a, b)

\S4method{lbeta}{dual,dual}(a, b)

\S4method{lbeta}{dual,numeric}(a, b)

\S4method{lbeta}{numeric,dual}(a, b)

\S4method{gamma}{dual}(x)

\S4method{lgamma}{dual}(x)

\S4method{psigamma}{dual}(x, deriv = 0L)

\S4method{digamma}{dual}(x)

\S4method{trigamma}{dual}(x)

\S4method{choose}{dual,dual}(n, k)

\S4method{choose}{numeric,dual}(n, k)

\S4method{choose}{dual,numeric}(n, k)

\S4method{lchoose}{dual,dual}(n, k)

\S4method{lchoose}{numeric,dual}(n, k)

\S4method{lchoose}{dual,numeric}(n, k)

\S4method{factorial}{dual}(x)

\S4method{lfactorial}{dual}(x)
}
\arguments{
\item{a}{non-negative numeric value or dual object with non-negative real part.}

\item{b}{non-negative numeric value or dual object with non-negative real part.}

\item{x}{dual object or numeric value.}

\item{deriv}{integer value.}

\item{n}{dual object or numeric value.}

\item{k}{dual object or numeric value.}
}
\value{
A dual object containing the transformed values according to the chosen function.
}
\description{
Special mathematical functions related to the beta and gamma.
}
\examples{
x <- dual(0.5, 1)
a <- dual(1.2, 1:0)
b <- dual(2.1, 0:1)

beta(a, b)
beta(1, b)
beta(a, 1)
lbeta(a, b)
lbeta(1, b)
lbeta(a, 1)

gamma(x)
lgamma(x)
psigamma(x, deriv = 0)
digamma(x)
trigamma(x)
psigamma(x, 2)
psigamma(x, 3)


n <- 7.8 + a
k <- 5.6 + b
choose(n, k)
choose(5, k)
choose(n, 2)

lchoose(n, k)
lchoose(5, k)
lchoose(n, 2)

factorial(x)
lfactorial(x)

}
