% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_dates.R
\name{shift_dates}
\alias{shift_dates}
\title{Shift Dates to Start on a Specified Origin Year}
\usage{
shift_dates(x, origin = "1970-01-01")
}
\arguments{
\item{x}{A vector of date strings or Date objects representing the sequence to shift.}

\item{origin}{A date string or Date object specifying the desired origin year for the shifted dates.
Default is "1970-01-01".}
}
\value{
A vector of Date objects with the shifted dates starting on the same day-of-year in the specified origin year.
}
\description{
Shifts a vector of dates to start on the same day-of-year in a specified origin year
while preserving the relative difference in days among the observations.
This way the temporal pattern (e.g., seasonality) inherent to the original dates
will also be preserved in the shifted dates.
}
\details{
The primary goal of this function is to align a sequence of dates based on the day-of-year
in a desired origin year. This can be particularly useful for comparing or visualizing
two or more time series with different absolute dates but aiming to align them based on
the day-of-year or another relative metric.
}
\examples{

x <- c("2011-09-14", "2011-09-30", "2011-10-16", "2011-11-01")

shift_dates(x)

}
