% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{laparoscopy}
\alias{laparoscopy}
\title{Examples data for the dtComb package}
\format{
A data frame with 225 rows and 3 variables:
\describe{
\item{group}{Indicator if the procedure was needed, values needed and
not_needed}
\item{ddimer}{Biomarker 1, D-Dimer protein level in blood, ng/mL}
\item{log_leukocyte}{Biomarker 2, Logarithm of Leukocyte count in blood,
per mcL}
}
}
\usage{
data(laparoscopy)
}
\description{
A data set containing the results of diagnostic laparoscopy procedures for 225
patients.
}
\examples{
data(laparoscopy)
laparoscopy$group <- factor(laparoscopy$group)
gcol <- c("#E69F00", "#56B4E9")
plot(laparoscopy$ddimer, laparoscopy$log_leukocyte,
  col = gcol[as.numeric(laparoscopy$group)]
)

}
\keyword{datasets}
