% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_construction.R
\name{d_mat}
\alias{d_mat}
\title{Construct D matrix}
\usage{
d_mat(k, xd, tf_weighting = FALSE, row_idx = NULL)
}
\arguments{
\item{k}{Order for the discrete derivative matrix. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{tf_weighting}{Should "trend filtering weighting" be used? This is a
weighting of the discrete derivatives that is implicit in trend filtering;
see details for more information. The default is \code{FALSE}.}

\item{row_idx}{Vector of indices, a subset of \code{1:(n-k)} where \code{n = length(xd)}, that indicates which rows of the constructed matrix should be
returned. The default is \code{NULL}, which is taken to mean \code{1:(n-k)}.}
}
\value{
Sparse matrix of dimension \code{length(row_idx)} by \code{length(xd)}.
}
\description{
Constructs the discrete derivative matrix of a given order, with respect to
given design points.
}
\details{
The discrete derivative matrix of order \eqn{k}, with respect to
design points \eqn{x_1 < \ldots < x_n}, is denoted \eqn{D^k_n}. It has
dimension \eqn{(n-k) \times n}, and is banded with bandwidth \eqn{k+1}. It
can be constructed recursively, as follows. We first define the \eqn{(n-1)
  \times n} first difference matrix \eqn{\bar{D}_n}:
\deqn{
  \bar{D}_n =
  \left[\begin{array}{rrrrrr}
  -1 & 1 & 0 & \ldots & 0 & 0 \\
  0 & -1 & 1 & \ldots & 0 & 0 \\
  \vdots & & & & & \\
  0 & 0 & 0 & \ldots & -1 & 1
  \end{array}\right],
  }
and for \eqn{k \geq 1}, define the \eqn{(n-k) \times (n-k)} diagonal weight
matrix \eqn{W^k_n} to have diagonal entries \eqn{(x_{i+k} - x_i) / k},
\eqn{i = 1,\ldots,n-k}. The \eqn{k}th order discrete derivative matrix
\eqn{D^k_n} is then given by the recursion:
\deqn{
  \begin{aligned}
  D^1_n &= (W^1_n)^{-1} \bar{D}_n, \\
  D^k_n &= (W^k_n)^{-1} \bar{D}_{n-k+1} \, D^{k-1}_n,
  \quad \text{for $k \geq 2$}.
  \end{aligned}
  }
We note that \eqn{\bar{D}_{n-k+1}} above denotes the \eqn{(n-k) \times
  (n-k+1)} version of the first difference matrix that is defined in the
second-to-last display.

The option \code{tf_weighting = TRUE} returns \eqn{W^k_n D^k_n} where \eqn{W^k_n}
is the \eqn{(n-k) \times (n-k)} diagonal matrix as described above. This
weighting is implicit in trend filtering, as explained in the help file for
\code{\link[=d_mat_mult]{d_mat_mult()}}. See also Section 6.1 of Tibshirani (2020) for further
discussion.

\strong{Note:} For multiplication of a given vector by \eqn{D^k_n}, instead of
forming \eqn{D^k_n} with the current function and then carrying out the
multiplication, one should instead use \code{\link[=d_mat_mult]{d_mat_mult()}}, as this will be more
efficient (both will be linear time, but the latter saves the cost of
forming any matrix in the first place).
}
\examples{
d_mat(2, 1:10)
d_mat(2, 1:10 / 10)
d_mat(2, 1:10, row_idx = 2:5)
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Section 6.1.
}
\seealso{
\code{\link[=b_mat]{b_mat()}} for constructing the extended discrete derivative matrix,
and \code{\link[=d_mat_mult]{d_mat_mult()}} for multiplying by the discrete derivative matrix.
}
