% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsregion.R
\name{dsregion}
\alias{dspolygon}
\alias{dsregion}
\title{Polygonal Region}
\usage{
dsregion(..., col = "yellow", border = NA, behind = TRUE)

dspolygon(x, y, col = "yellow", border = NA, behind = TRUE)
}
\arguments{
\item{...}{Takes points which will act as corners. See example and details for usage.}

\item{col}{The color of the polygon}

\item{border}{The color of the border of the polygon.}

\item{behind}{Forces the polygon to be a background object for the purposes of layering.}

\item{x}{A numeric vector containing the x-values of each corner.}

\item{y}{A collection (for example: \code{c(1,2,3)}) of points on the y-axis
which correspond to the corners of the polygon.
Each member of the \code{y} parameter corresponds with a member of the \code{x}
parameter with the same index.}
}
\description{
Friendly function to create a polygon corresponding with given values of the polygon's corners.
The polygon is then colored automatically.
}
\section{Calling dspolygon Correctly}{


\code{\link{dspolygon}} takes the x and y points similar to the default \code{polygon} function.
The \code{x} parameter takes a numeric vector containing the x-values of each corner.
The \code{y} parameter takes a numeric vector containing the y-values of each corner.
The \code{x} and \code{y} coordinates of the corners of the polygon
will be the pairs made from the \code{x} and \code{y} parameters with equal indices.
}

\section{Calling dsregion Correctly}{


The \code{...} parameter in \code{dsregion} can take multiple
\code{\link{dspoint}}s, \code{pnt}s,
or simply vectors each containing two points \code{c(x,y)}.
See the examples if clarification is needed.
}
\examples{
library(dsmodels)

fun <- function(X,Y) {
  list(
    X/exp(Y),
    Y/exp(X)
  )
}
model <- dsmodel(fun, title = "Regions!")
range <- dsrange(3, 3, discretize = .09)
model+range

# dspolygon usage
model + dspolygon(x = c(-.05,3,3),
                  y = c(0,0,3),
                  col = "yellow")
a <- dspoint(3,3)
b <- dspoint(2.5,3)
c <- dspoint(2,2)

# Different inputs for dsregion shown below

model + dsregion(a, b, c, col = "orange") +
	dsregion(pnt(0,0),pnt(1,0),pnt(1,1),pnt(0,1), col = "green") +
	dsregion(c(1,1),c(2,1),c(2,2),c(1,2), c(1.8,1.5), col = "magenta")
}
\seealso{
\code{\link{dspoint}}

\code{\link{guessattractors}}

\code{\link{guessregions}}
}

