% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomper.R
\name{dcomper}
\alias{dcomper}
\alias{pcomper}
\alias{qcomper}
\alias{rcomper}
\title{Composed-Error distribution}
\usage{
dcomper(
  x,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  distr = "normhnorm",
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

pcomper(
  q,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  distr = "normhnorm",
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

qcomper(
  p,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  distr = "normhnorm",
  log.p = FALSE
)

rcomper(n, mu = 0, sigma_v = 1, sigma_u = 1, s = -1, distr = "normhnorm")
}
\arguments{
\item{x}{numeric vector of quantiles.}

\item{mu}{numeric vector of \eqn{\mu}.}

\item{sigma_v}{numeric vector of \eqn{\sigma_V}. Must be positive.}

\item{sigma_u}{numeric vector of \eqn{\sigma_U}. Must be positive.}

\item{s}{integer; \eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{distr}{string; determines the distribution:\cr
`normhnorm`, Normal-halfnormal distribution \cr
`normexp`, Normal-exponential distribution \cr}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional; index matrix for upper triangular, generated by \code{\link{trind_generator}}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{numeric vector of quantiles.}

\item{p}{numeric vector of probabilities.}

\item{n}{positive integer; number of observations.}
}
\value{
\code{dcomper()} gives the density, \code{pcomper()} give the distribution function, \code{qcomper()} gives the quantile function, and \code{rcomper()} generates random numbers, with given parameters.
\code{dcomper()} and \code{pcomper()} returns a \code{derivs} object.
}
\description{
Probablitiy density function, distribution, quantile function and random number generation for the composed-error distribution
}
\details{
This is wrapper function for the normal-halfnormal and normal-exponential distribution. A random variable \eqn{X} follows a composed error distribution if \eqn{X = V + s \cdot U }, where \eqn{V \sim N(\mu, \sigma_V^2)} and \eqn{U \sim HN(0,\sigma_U^2)} or \eqn{U \sim Exp(\sigma_U^2)}.
For more details see \code{\link{dnormhnorm}} and \code{\link{dnormexp}}. Here, \eqn{s=-1} for production and \eqn{s=1} for cost function.
}
\section{Functions}{
\itemize{
\item \code{pcomper()}: distribution function for the composed-error distribution.

\item \code{qcomper()}: quantile function for the composed-error distribution.

\item \code{rcomper()}: random number generation for the composed-error distribution.

}}
\examples{
pdf <- dcomper(x=5, mu=1, sigma_v=2, sigma_u=3, s=-1, distr="normhnorm")
cdf <- pcomper(q=5, mu=1, sigma_v=2, sigma_u=3, s=-1, distr="normhnorm")
q <- qcomper(p=seq(0.1, 0.9, by=0.1), mu=1, sigma_v=2, sigma_u=3, s=-1, distr="normhnorm")
r <- rcomper(n=10, mu=1, sigma_v=2, sigma_u=3, s=-1, distr="normhnorm")

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
\item \insertRef{gradshteyn2014table}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
\seealso{
Other distribution: 
\code{\link{dcomper_mv}()},
\code{\link{dnormexp}()},
\code{\link{dnormhnorm}()}
}
\concept{distribution}
