% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reference.R
\name{get_reference}
\alias{get_reference}
\title{Get D-score reference}
\usage{
get_reference(population = "gcdg", references = dscore::builtin_references)
}
\arguments{
\item{population}{A string describing the population. Currently supported
are \code{"dutch"}, \code{"gcdg"} and \code{"phase1"}.}

\item{references}{A \code{data.frame} with the same structure
as \code{builtin_references}. The default is to use
\code{builtin_references}.}
}
\value{
A \code{data.frame} with the LMS reference values.
}
\description{
The \code{get_reference()} function selects the D-score reference
distribution.
}
\note{
No references for population \code{"gsed"} exist.
The function will silently rewrite \code{population = "gsed"}
into to the \code{population = "gsed"}.

The \code{"dutch"} reference was published in Van Buuren (2014)
The \code{"gcdg"} was calculated from 15 cohorts with direct
observations (Weber, 2019).
The \code{"phase1"} references were calculated from the GSED Phase 1 validation
data (GSED-BGD, GSED-PAK, GSED-TZA) cover age range 2w-3.5 years. The
age range 3.5-5 yrs is linearly extrapolated and are only indicative.
}
\references{
Van Buuren S (2014). Growth charts of human development.
Stat Methods Med Res, 23(4), 346-368.

Weber AM, Rubio-Codina M, Walker SP, van Buuren S, Eekhout I,
Grantham-McGregor S, Caridad Araujo M, Chang SM, Fernald LCH,
Hamadani JD, Hanlon A, Karam SM, Lozoff B, Ratsifandrihamanana L,
Richter L, Black MM (2019). The D-score: a metric for interpreting
the early development of infants and toddlers across global settings.
BMJ Global Health, BMJ Global Health 4: e001724.
\url{https://gh.bmj.com/content/bmjgh/4/6/e001724.full.pdf}.
}
\seealso{
\code{\link[=builtin_references]{builtin_references()}}
}
