% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\docType{data}
\name{Umlaut}
\alias{Umlaut}
\title{Umlaut provides German Umlaut letters (as Unicode characters).}
\format{
An object of class \code{character} of length 7.
}
\usage{
Umlaut
}
\description{
\code{Umlaut} provides the German Umlaut letters (aka. diaeresis/diacritic) 
as a named character vector.
}
\details{
For Unicode details, see 
\url{https://home.unicode.org/}, 

For details on German Umlaut letters (aka. diaeresis/diacritic), see 
\url{https://en.wikipedia.org/wiki/Diaeresis_(diacritic)} and 
\url{https://en.wikipedia.org/wiki/Germanic_umlaut}.
}
\examples{
Umlaut
names(Umlaut)

paste0("Hansj", Umlaut["o"], "rg i", Umlaut["s"], "t s", Umlaut["u"], "sse ", Umlaut["A"], "pfel.")
paste0("Das d", Umlaut["u"], "nne M", Umlaut["a"], "dchen l", Umlaut["a"], "chelt.")
paste0("Der b", Umlaut["o"], "se Mann macht ", Umlaut["u"], "blen ", Umlaut["A"], "rger.")
paste0("Das ", Umlaut["U"], "ber-Ich ist ", Umlaut["a"], "rgerlich.")

}
\seealso{
Other text objects and functions: 
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
\keyword{datasets}
