% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm_binary.R
\name{pgo_binary}
\alias{pgo_binary}
\title{Probability to go to phase III for multiarm programs with binary distributed outcomes}
\usage{
pgo_binary(RRgo, n2, p0, p11, p12, strategy, case)
}
\arguments{
\item{RRgo}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{p0}{assumed true rate of control group}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{strategy}{choose Strategy: 1 ("only best promising"), 2 ("all promising")}

\item{case}{different cases: 1 ("nogo"), 21 (treatment 1 is promising, treatment 2 is not), 22 (treatment 2 is promising, treatment 1 is not), 31 (both treatments are promising, treatment 1 is better), 32 (both treatments are promising, treatment 2 is better)}
}
\value{
The function pgo_binary() returns the probability to go to phase III.
}
\description{
Given our parameters this function calculates the probability to go to phase III after the second phase was conducted. The considered strategies are as follows:
\itemize{
\item 
\enumerate{
\item Strategy: Only best promising treatment goes to phase III
}
}
}
\examples{
res <- pgo_binary(RRgo = 0.8 ,n2 = 50 ,p0 = 0.6, p11 =  0.3, p12 = 0.5,strategy = 2, case = 31)
}
\keyword{internal}
