% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.HarbronFit.R
\name{plot.HarbronFit}
\alias{plot.HarbronFit}
\title{Plot method for \code{HarbronFit} objects}
\usage{
\method{plot}{HarbronFit}(x, y = NULL, which = c("nls", "2d", "3d"), ...)
}
\arguments{
\item{x}{A \code{HarbronFit} object returned by \code{\link{fitModel}}.}

\item{y}{A (optional) second \code{HarbronFit} object returned by 
\code{\link{fitModel}}. If provided, \code{which} argument is ignored and 
a 2d-plot comparing two model fits is produced. Note that the two models 
should have been fitted on the same data. Note that this argument can also 
be used as \code{which}. See examples.}

\item{which}{Whether to show default \code{\link[nlme]{plot.nls}} ("nls"), 
a 'slice' plot with fitted curves overlaid on top of the observed data ("2d")
or a 3d-plot with fitted surface overlaid on top of the observed data ("3d").}

\item{...}{Further arguments passed to \code{\link[nlme]{plot.nls}}, 
\code{\link{fitPlot2d}} or \code{\link{fitPlot3d}} depending on \code{which}.}
}
\value{
Output from \code{\link[nlme]{plot.nls}}, a \code{ggplot2} object if 
\code{which = "2d"}, or a 3d \code{rgl} plot if \code{which = "3d"}.
}
\description{
Diagnostic and goodness-of-fit plots (in 2D and 3D).
}
\examples{
\donttest{
data("checkerboardData", package = "drugCombo")
data1 <- checkerboardData[checkerboardData$exp == 1, ]
fitUniform <- fitModel(data1, model = "uniform")
fitLinear <- fitModel(data1, model = "linear1")
plot(fitUniform, fitLinear)
plot(fitLinear, "2d")  # here 2nd argument is interpreted as `which`
}
}
\author{
Maxim Nazarov
}
