% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{determine_double_hit_genes}
\alias{determine_double_hit_genes}
\title{Determine Double-Hit Genes}
\usage{
determine_double_hit_genes(
  annovar_csv_path,
  gene_SCNA_df,
  log2_hom_loss_threshold = -1,
  batch_analysis = FALSE
)
}
\arguments{
\item{annovar_csv_path}{path to 'ANNOVAR' csv output file}

\item{gene_SCNA_df}{data frame of gene-level SCNAs (output of \code{\link{create_gene_level_scna_df}})}

\item{log2_hom_loss_threshold}{to determine double-hit events, the
\ifelse{html}{\out{log<sub>2</sub>}}{\eqn{log_2}} threshold for identifying
homozygous loss events (default = -1).}

\item{batch_analysis}{boolean to indicate whether to perform batch analysis
(\code{TRUE}, default) or personalized analysis (\code{FALSE}). If \code{TRUE},
a column named 'tumor_id' should be present in both the ANNOVAR csv and the SCNA
table.}
}
\value{
vector of gene symbols that are subject to double-hit event(s), i.e.
non-synonymous mutation + homozygous CN loss
}
\description{
Determine Double-Hit Genes
}
