% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rem_simulate.R
\name{simulateRESeq}
\alias{simulateRESeq}
\title{Simulate a Random One-Mode Relational Event Sequence}
\usage{
simulateRESeq(
  n_actors,
  n_events,
  inertia = FALSE,
  inertia_p = 0,
  recip = FALSE,
  recip_p = 0,
  sender_outdegree = FALSE,
  sender_outdegree_p = 0,
  sender_indegree = FALSE,
  sender_indegree_p = 0,
  target_outdegree = FALSE,
  target_outdegree_p = 0,
  target_indegree = FALSE,
  target_indegree_p = 0,
  assort = FALSE,
  assort_p = 0,
  trans_trips = FALSE,
  trans_trips_p = 0,
  three_cycles = FALSE,
  three_cycles_p = 0,
  starting_events = NULL,
  returnStats = FALSE
)
}
\arguments{
\item{n_actors}{The number of potential actors in the event sequence.}

\item{n_events}{The number of simulated events for the relational event sequence.}

\item{inertia}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{inertia_p}{If \emph{inertia} = TRUE, the numerical value that corresponds to the parameter weight for the inertia statistic.}

\item{recip}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{recip_p}{If \emph{recip} = TRUE, the numerical value that corresponds to the parameter weight for the reciprocity statistic.}

\item{sender_outdegree}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{sender_outdegree_p}{If \emph{sender_outdegree} = TRUE, the numerical value that corresponds to the parameter weight for the outdegree statistic.}

\item{sender_indegree}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{sender_indegree_p}{If \emph{sender_indegree} = TRUE, the numerical value that corresponds to the parameter weight for the indegree statistic.}

\item{target_outdegree}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{target_outdegree_p}{If \emph{target_outdegree} = TRUE, the numerical value that corresponds to the parameter weight for the outdegree statistic.}

\item{target_indegree}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{target_indegree_p}{If \emph{target_indegree} = TRUE, the numerical value that corresponds to the parameter weight for the indegree statistic.}

\item{assort}{Boolean. TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{assort_p}{If \emph{assort} = TRUE, the numerical value that corresponds to the parameter weight for the assortativity statistic.}

\item{trans_trips}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{trans_trips_p}{If \emph{trans_trips} = TRUE, the numerical value that corresponds to the parameter weight for the transitive triplets statistic.}

\item{three_cycles}{TRUE/FALSE. True indicates the effect will be included (see the details section). FALSE indicates the effect will not be included.}

\item{three_cycles_p}{If \emph{three_cycles} = TRUE, the numerical value that corresponds to the parameter weight for the three cycles statistic.}

\item{starting_events}{A \emph{n} x 2 dataframe with \emph{n} starting events and 2 columns. The first column should be the sender and the second should be the target.}

\item{returnStats}{TRUE/FALSE. TRUE indicates that the requested network statistics will be returned alongside the simulated relational event sequence. FALSE indicates that only the simulated relational event sequence will be returned. Set to FALSE by default.}
}
\value{
A data frame that contains the simulated relational event sequence with the sufficient statistics (if requested).
}
\description{
The function allows users to simulate a random one-mode relational event sequence
between \emph{n} actors for \emph{k} events. Importantly, this function follows the methods
discussed in Butts (2008), Amati, Lomi, and Snijders (2024), and Scheter and
Quintane (2021). See the details for more information on this algorithm. Critically,
this function can be used to simulate a random event sequence, to assess the goodness of
fit for ordinal timing relational event models (see Amati, Lomi, and Snijders 2024), and simulate
random outcomes for relational outcome models.
}
\details{
Following the authors listed in the descriptions section, the probability of
selecting a new event for \emph{t+1} based on the past relational history, \emph{\eqn{H_{t}}},  from \emph{\eqn{0<t<t+1}}
is given by:

\deqn{ p(e_{t}) = \frac{\lambda{ij}(t;\theta)}{\sum_{(u,v)\in R_{t}} \lambda_{uv}(t;\theta)} }

where \emph{(i,j,t)} is the triplet that corresponds to the dyadic pair with sender \emph{i}
and target \emph{j} at time \emph{t} contained in the full risk set, \emph{\eqn{R_{t}}}, based on the
past relational history. \eqn{\lambda_{ij}(t;\theta)} is formulated as:

\deqn{ \lambda_{ij}(t;\theta) = e^{\sum_{p}\theta_{p} X_{ijp}(H_{t})} }

where \eqn{\theta_{p}} corresponds to the specific parameter weight given by the
user, and  \eqn{X_{ijp}} represents the value of the specific statistic based on the
current past relational history \emph{\eqn{H_{t}}}.

Following Scheter and Quintane (2021) and Amati, Lomi, and Snijders (2024), the
algorithm for simulating the random relational sequence for \emph{k} events is:
\itemize{
\item 1. Initialize the full risk set, \emph{\eqn{R_{t}}}, which is the full Cartesian plot of actors.
\item 2. Randomly sample the first event \eqn{ e_{1} } and add that event into the relational history, \emph{\eqn{H_{t}}}.
\item 3. Until \emph{i} = \emph{k}, compute the sufficient statistics for each event in the risk set,
sample a new event \eqn{ e_{i} } based on the probability function specified above, and add that element into the relational history.
\item 4. End when \emph{i} > \emph{k}.
}

Currently, the function supports 6 statistics for one-mode networks. These are:
\itemize{
\item Inertia: \eqn{{n}_{ijt}}
\item Reciprocity: \eqn{{n}_{jit}}
\item Target Indegree: \eqn{\sum_{k} {n}_{kjt}}
\item Target Outdegree: \eqn{\sum_{k} {n}_{jkt}}
\item Sender Outdegree: \eqn{\sum_{k} {n}_{ikt}}
\item Sender Indegree: \eqn{\sum_{k} {n}_{kit}}
\item Assortativity: \eqn{\sum_{k} {n}_{kit} \cdot \sum_{k} {n}_{ikt}}
\item Transitive Triplets: \eqn{\sum_{k} {n}_{ikt} \cdot {n}_{kjt}}
\item Three Cycles: \eqn{\sum_{k} {n}_{jkt} \cdot {n}_{kit}}
}
Where \emph{n} represents the counts of past events, \emph{i} is the event sender, and \emph{j} is the event target. See Scheter and Quintane (2021)
and Butts (2008) for a further discussion of these statistics.

Users are allowed to insert a starting event sequence to base the simulation on. A few things are worth nothing. The starting
event sequence should be a matrix with \emph{n} rows indicating the number of starting events and 2 columns, with the
first representing the event senders and the second column representing the event targets. Internally, the number
of actors is ignored, as the number of possible actors in the risk set is based only on the actors present in the
starting event sequence. Finally, the sender and target actor IDs should be numerical values.
}
\examples{
#Creating a random relational sequence with 5 actors and 25 events
rem1<- simulateRESeq(n_actors = 25,
                     n_events = 1000,
                     inertia = TRUE,
                     inertia_p = 0.12,
                     recip = TRUE,
                     recip_p = 0.08,
                     sender_outdegree = TRUE,
                     sender_outdegree_p = 0.09,
                     target_indegree = TRUE,
                     target_indegree_p = 0.05,
                     assort = TRUE,
                     assort_p = -0.01,
                     trans_trips = TRUE,
                     trans_trips_p = 0.09,
                     three_cycles = TRUE,
                     three_cycles_p = 0.04,
                     starting_events = NULL,
                     returnStats = TRUE)
rem1

#Creating a random relational sequence with 100 actors and 1000 events with
#only inertia and reciprocity
rem2 <- simulateRESeq(n_actors = 100,
                     n_events = 1000,
                     inertia = TRUE,
                     inertia_p = 0.12,
                     recip = TRUE,
                     recip_p = 0.08,
                     returnStats = TRUE)
rem2

#Creating a random relational sequence based on the starting sequence with
#only inertia and reciprocity
rem3 <- simulateRESeq(n_actors = 100, #does not matter can be any value, this is
                                    #overridden by the starting event sequence
                    n_events = 100,
                    inertia = TRUE,
                    inertia_p = 0.12,
                    recip = TRUE,
                    recip_p = 0.08,
                    #a random starting event sequence
                    starting_events = matrix(c(1:10, 10:1),
                    nrow = 10, ncol = 2,  byrow = FALSE),
                    returnStats = TRUE)
rem3
}
\references{
Amati, Viviana, Alessandro Lomi, and Tom A.B. Snijders. 2024. "A goodness of fit
framework for relational event models." \emph{Journal of the Royal Statistical Society Series A: Statistics in Society}
187(4): 967-988.

Butts, Carter T. "A Relational Framework for Social Action." \emph{Sociological Methodology}
38: 155-200.

Schecter, Aaron and Eric Quintane. 2021 "The Power, Accuracy, and Precision of the Relational
Event Model." \emph{Organizational Research Methods} 24(4): 802-829.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
