% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic5.R
\name{logistic5_fn}
\alias{logistic5_fn}
\title{5-parameter logistic function}
\usage{
logistic5_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the logistic function is to be evaluated.}

\item{theta}{numeric vector with the five parameters in the form
\code{c(alpha, beta, eta, phi, nu)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
logistic function.
}
\description{
Evaluate at a particular set of parameters the 5-parameter logistic function.
}
\details{
The 5-parameter logistic function \verb{f(x; theta)} is defined here as

\code{alpha + (beta - alpha) / (1 + nu * exp(-eta * (x - phi)))^(1 / nu)}

where \code{theta = c(alpha, beta, eta, phi, nu)}, \code{beta > alpha}, and \code{nu > 0}.
}
