% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruneRepo.R
\name{pruneRepo}
\alias{pruneRepo}
\title{Prune repository from older copies of packages}
\usage{
pruneRepo(
  repopath = getOption("dratRepo", "~/git/drat"),
  type = "source",
  pkg,
  version = getRversion(),
  remove = FALSE
)
}
\arguments{
\item{repopath}{Character variable with the path to the repo;
defaults to the value of the \dQuote{dratRepo} option with
\dQuote{"~/git/drat"} as fallback}

\item{type}{Character variable for the type of repository, so far
\dQuote{source}, \dQuote{win.binary}, \dQuote{mac.binary}, 
\dQuote{mac.binary.mavericks} or \dQuote{mac.binary.el-capitan}}

\item{pkg}{Optional character variable specifying a package name,
whose older versions should be pruned. If missing (the
default), pruning is performed on all packages.}

\item{version}{R version information in the format \code{X.Y} or 
\code{X.Y.Z}. Only used, if pruning binary packages. 
(default: \code{version = getRversion()})}

\item{remove}{Character or logical variable indicating whether
files should be removed. Nothing happens if \sQuote{FALSE}. If
different from (logical) \sQuote{FALSE} and equal to character
\dQuote{git} files are removed via \code{git rm} else via a
straight file deletion.}
}
\value{
A data frame describing the repository is returned
 containing columns with columns \dQuote{file},
 \dQuote{package} (just the name), \dQuote{version} and a
 logical variable \dQuote{newest} indicating if the package can
 be removed.
}
\description{
The function determines which packages in a repositories can be
removed as they are being \sQuote{shadowed} by a newer version of
the same packages.
}
\details{
Given a package name, R will always find the newest version of
that package. Older versions are therefore effectively shadowed
and can be removed without functionally changing a repository.

This function is still undergoing development and polish and may
change in subsequent versions.
}
\author{
Dirk Eddelbuettel
}
