% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{configure_cache}
\alias{configure_cache}
\title{Configure the hash algorithms, etc. of a drake cache.
\lifecycle{deprecated}}
\usage{
configure_cache(cache = drake::get_cache(verbose = verbose),
  short_hash_algo = drake::default_short_hash_algo(cache = cache),
  long_hash_algo = drake::default_long_hash_algo(cache = cache),
  log_progress = FALSE, overwrite_hash_algos = FALSE, verbose = 1L,
  jobs = 1, init_common_values = FALSE)
}
\arguments{
\item{cache}{Cache to configure}

\item{short_hash_algo}{Short hash algorithm for drake.
The short algorithm must be among \code{\link[=available_hash_algos]{available_hash_algos()}},
which is just the collection of algorithms available to the \code{algo}
argument in \code{\link[digest:digest]{digest::digest()}}.
See \code{\link[=default_short_hash_algo]{default_short_hash_algo()}} for more.}

\item{long_hash_algo}{Long hash algorithm for drake.
The long algorithm must be among \code{\link[=available_hash_algos]{available_hash_algos()}},
which is just the collection of algorithms available to the \code{algo}
argument in \code{digest::digest()}.
See \code{\link[=default_long_hash_algo]{default_long_hash_algo()}} for more.}

\item{log_progress}{Deprecated logical.
Previously toggled whether to clear the recorded
build progress if this cache was used for previous calls to
\code{\link[=make]{make()}}.}

\item{overwrite_hash_algos}{Logical, whether to try to overwrite
the hash algorithms in the cache with any user-specified ones.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{jobs}{Number of jobs for parallel processing}

\item{init_common_values}{Logical, whether to set the initial \code{drake}
version in the cache and other common values.
Not always a thread safe operation, so should only be \code{TRUE}
on the master process}
}
\value{
A drake/storr cache.
}
\description{
The purpose of this function is
to prepare the cache to be called from \code{\link[=make]{make()}}.
\code{drake} only uses a single hash algorithm now,
so we no longer need this configuration step.
}
\details{
Deprecated on 2018-12-12.
}
\keyword{internal}
