% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\title{Invalidate and deregister targets.
\lifecycle{maturing}}
\usage{
clean(..., list = character(0), destroy = FALSE, path = NULL,
  search = NULL, cache = drake::drake_cache(path = path, verbose =
  verbose), verbose = 1L, jobs = 1, force = FALSE,
  garbage_collection = FALSE, purge = FALSE)
}
\arguments{
\item{...}{Targets to remove from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{list}{Character vector naming targets to be removed from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{destroy}{Logical, whether to totally remove the drake cache.
If \code{destroy} is \code{FALSE}, only the targets
from \code{make()}
are removed. If \code{TRUE}, the whole cache is removed, including
session metadata, etc.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{jobs}{Number of jobs for light parallelism
(disabled on Windows).}

\item{force}{Logical, whether to try to clean the cache
even though the project may not be back compatible with the
current version of drake.}

\item{garbage_collection}{Logical, whether to call
\code{cache$gc()} to do garbage collection.
If \code{TRUE}, cached data with no remaining references
will be removed.
This will slow down \code{clean()}, but the cache
could take up far less space afterwards.
See the \code{gc()} method for \code{storr} caches.}

\item{purge}{Logical, whether to remove objects from
metadata namespaces such as "meta", "build_times", and "errors".}
}
\value{
Invisibly return \code{NULL}.
}
\description{
Force targets to be out of date and remove target names
from the data in the cache.
}
\details{
By default, \code{\link[=clean]{clean()}} invalidates \strong{all} targets,
so be careful. \code{\link[=clean]{clean()}} always:
\enumerate{
\item Forces targets to be out of date so the next \code{\link[=make]{make()}}
does not skip them.
\item Deregisters targets so \code{loadd(your_target)} and \code{readd(your_target)}
no longer work.
}

By default, \code{clean()} does not actually remove the underlying data.
Even old targets from the distant past are still in the cache
and recoverable via \code{drake_history()} and \code{make(recover = TRUE)}.
To actually remove target data from the cache, as well as any
\code{\link[=file_out]{file_out()}} files from any targets you are currently cleaning,
run \code{clean(garbage_collection = TRUE)}.
Garbage collection is slow, but it reduces the storage burden of the cache.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
# Show all registered targets in the cache.
cached()
# Deregister 'summ_regression1_large' and 'small' in the cache.
clean(summ_regression1_large, small)
# Those objects are no longer registered as targets.
cached()
# Rebuild the invalidated/outdated targets.
make(my_plan)
# Clean everything.
clean()
# But the data objects and files are not actually gone!
file.exists("report.md")
drake_history()
make(my_plan, recover = TRUE)
# You need garbage collection to actually remove the data
# and any file_out() files of any uncleaned targets.
clean(garbage_collection = TRUE)
drake_history()
make(my_plan, recover = TRUE)
}
})
}
}
\seealso{
\code{\link[=drake_gc]{drake_gc()}}, \code{\link[=make]{make()}}
}
