% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan.R
\name{target}
\alias{target}
\title{Define custom columns in a \code{\link[=drake_plan]{drake_plan()}}.}
\usage{
target(command = NULL, trigger = NULL, retries = NULL,
  timeout = NULL, cpu = NULL, elapsed = NULL, priority = NULL,
  worker = NULL, resources = NULL, ...)
}
\arguments{
\item{command}{the command to build the target}

\item{trigger}{the target's trigger}

\item{retries}{number of retries in case of failure}

\item{timeout}{overall timeout (in seconds) for building a target}

\item{cpu}{cpu timeout (seconds) for building a target}

\item{elapsed}{elapsed time (seconds) for building a target}

\item{priority}{integer giving the build priority of a target.
Given two targets about to be built at the same time,
the one with the lesser priority (numerically speaking)
will be built first.}

\item{worker}{the preferred worker to be assigned the target
(in parallel computing).}

\item{resources}{Experimental, no guarantees that this works all the time.
Same as the \code{resources} argument to \code{batchtools_slurm()}
and related \code{future.bachtools} functions.
See also \url{https://github.com/HenrikBengtsson/future.batchtools#examples}. # nolint
\code{resources} is a list of computing resource parameters for the target.
Each element is a value passed to a \code{brew} placeholder of a
\code{batchtools} template file. The list names of \code{resources}
should be the brew patterns.}

\item{...}{named arguments specifying non-standard
fields of the workflow plan.}
}
\value{
A one-row workflow plan data frame with the named
arguments as columns.
}
\description{
The \code{target()} function lets you define
custom columns in a workflow plan data frame, both
inside and outside calls to \code{\link[=drake_plan]{drake_plan()}}.
}
\details{
Tidy evaluation is applied to the arguments,
and the \code{!!} operator is evaluated immediately
for expressions and language objects.
}
\examples{
# Use target() to create your own custom columns in a drake plan.
# See ?triggers for more on triggers.
plan <- drake_plan(
  website_data = target(
    download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data),
  strings_in_dots = "literals"
)
plan
# make(plan) # nolint
# Call target() inside or outside drake_plan().
target(
  download_data("www.your_url.com"),
  trigger = "always",
  custom_column = 5
)
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
