% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{knitr_deps}
\alias{knitr_deps}
\title{Find the drake dependencies of a dynamic knitr report target.}
\usage{
knitr_deps(target)
}
\arguments{
\item{target}{file path to the file or name of the file target,
source text of the document.}
}
\value{
A character vector of the names of dependencies.
}
\description{
To enable drake to watch for the dependencies
of a knitr report, the command in your workflow plan data frame
must call \code{\link[knitr:knit]{knitr::knit()}} directly.
In other words,
the command must look something like
\code{knit("your_report.Rmd")} or
\code{knit("your_report.Rmd", quiet = TRUE)}.
}
\details{
Drake looks for dependencies in the document by
analyzing evaluated code chunks for other targets/imports
mentioned in \code{\link[=loadd]{loadd()}} and \code{\link[=readd]{readd()}}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
knitr_deps("'report.Rmd'") # Files must be single-quoted.
# Find the dependencies of the compiled output target, 'report.md'.
knitr_deps("report.Rmd")
make(my_plan) # Run the project.
# Work only on the Rmd source, not the output.
try(knitr_deps("'report.md'"), silent = FALSE) # error
})
}
}
\seealso{
\code{\link[=deps]{deps()}},
\code{\link[=make]{make()}}, \code{\link[=load_basic_example]{load_basic_example()}}
}
