% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{drake_quotes}
\alias{drake_quotes}
\title{Put quotes around each element of a character vector.}
\usage{
drake_quotes(x = NULL, single = FALSE)
}
\arguments{
\item{x}{character vector or object to be coerced to character.}

\item{single}{Add single quotes if \code{TRUE}
and double quotes otherwise.}
}
\value{
character vector with quotes around it
}
\description{
Quotes are important in drake.
In workflow plan data frame commands,
single-quoted targets denote physical files,
and double-quoted strings are treated as ordinary string literals.
}
\examples{
# Single-quote this string.
drake_quotes("abcd", single = TRUE) # "'abcd'"
# Double-quote this string.
drake_quotes("abcd") # "\\"abcd\\""
}
\seealso{
\code{\link[=drake_unquote]{drake_unquote()}}, \code{\link[=drake_strings]{drake_strings()}}
}
