% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-filter.R
\name{filter_all}
\alias{filter_all}
\alias{filter_if}
\alias{filter_at}
\title{Filter within a selection of variables}
\usage{
filter_all(.tbl, .vars_predicate, .preserve = FALSE)

filter_if(.tbl, .predicate, .vars_predicate, .preserve = FALSE)

filter_at(.tbl, .vars, .vars_predicate, .preserve = FALSE)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.vars_predicate}{A quoted predicate expression as returned by
\code{\link[=all_vars]{all_vars()}} or \code{\link[=any_vars]{any_vars()}}.

Can also be a function or purrr-like formula. In this case, the
intersection of the results is taken by default and there's
currently no way to request the union.}

\item{.preserve}{when \code{FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Scoped verbs (\verb{_if}, \verb{_at}, \verb{_all}) have been superseded by the use of
\code{\link[=across]{across()}} in an existing verb. See \code{vignette("colwise")} for details.

These \link{scoped} filtering verbs apply a predicate expression to a
selection of variables. The predicate expression should be quoted
with \code{\link[=all_vars]{all_vars()}} or \code{\link[=any_vars]{any_vars()}} and should mention the pronoun
\code{.} to refer to variables.
}
\section{Grouping variables}{


The grouping variables that are part of the selection are taken
into account to determine filtered rows.
}

\examples{
# While filter() accepts expressions with specific variables, the
# scoped filter verbs take an expression with the pronoun `.` and
# replicate it over all variables. This expression should be quoted
# with all_vars() or any_vars():
all_vars(is.na(.))
any_vars(is.na(.))


# You can take the intersection of the replicated expressions:
filter_all(mtcars, all_vars(. > 150))
# ->
filter(mtcars, if_all(everything(), ~ .x > 150))

# Or the union:
filter_all(mtcars, any_vars(. > 150))
# ->
filter(mtcars, if_any(everything(), ~ . > 150))


# You can vary the selection of columns on which to apply the
# predicate. filter_at() takes a vars() specification:
filter_at(mtcars, vars(starts_with("d")), any_vars((. \%\% 2) == 0))
# ->
filter(mtcars, if_any(starts_with("d"), ~ (.x \%\% 2) == 0))

# And filter_if() selects variables with a predicate function:
filter_if(mtcars, ~ all(floor(.) == .), all_vars(. != 0))
# ->
is_int <- function(x) all(floor(x) == x)
filter(mtcars, if_all(where(is_int), ~ .x != 0))
}
\keyword{internal}
