% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy-to.r
\name{copy_to}
\alias{copy_to}
\title{Copy a local data frame to a remote src}
\usage{
copy_to(dest, df, name = deparse(substitute(df)), overwrite = FALSE, ...)
}
\arguments{
\item{dest}{remote data source}

\item{df}{local data frame}

\item{name}{name for new remote table.}

\item{overwrite}{If \code{TRUE}, will overwrite an existing table with
name \code{name}. If \code{FALSE}, will throw an error if \code{name} already
exists.}

\item{...}{other parameters passed to methods.}
}
\value{
a \code{tbl} object in the remote source
}
\description{
This function uploads a local data frame into a remote data source, creating
the table definition as needed. Wherever possible, the new object will be
temporary, limited to the current connection to the source.
}
\examples{
\dontrun{
iris2 <- src_memdb() \%>\% copy_to(iris, overwrite = TRUE)
iris2
}
}
\seealso{
\code{\link[=collect]{collect()}} for the opposite action; downloading remote data into
a local dbl.
}
