% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{arrange}
\alias{arrange}
\alias{arrange_}
\title{Arrange rows by variables.}
\usage{
arrange(.data, ...)

arrange_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link[dtplyr]{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Comma separated list of unquoted variable names. Use
\code{\link{desc}} to sort a variable in descending order.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\value{
An object of the same class as \code{.data}.

  Data frame row names are silently dropped. To preserve, convert to an
  explicit variable.
}
\description{
Use \code{\link{desc}} to sort a variable in descending order. Generally,
this will not also automatically order by grouping variables.
}
\section{Locales}{


Note that for local data frames, the ordering is done in C++ code which
does not have access to the local specific ordering usually done in R.
This means that strings are ordered as if in the C locale.
}
\examples{
arrange(mtcars, cyl, disp)
arrange(mtcars, desc(disp))
}
\seealso{
Other single.table.verbs: \code{\link{filter}},
  \code{\link{mutate}}, \code{\link{select}},
  \code{\link{slice}}, \code{\link{summarise}}
}

