% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/glimpse.R
\name{glimpse}
\alias{glimpse}
\title{Get a glimpse of your data.}
\usage{
glimpse(tbl, width = getOption("width"))
}
\arguments{
\item{tbl}{A data table}

\item{width}{Width of output: defaults to the width of the console.}
}
\description{
This is like a transposed version of print: columns run down the page,
and data runs across. This makes it possible to see every column in
a data frame. It's a little like \code{\link{str}} applied to a data frame
but it tries to show you as much data as possible. (And it always shows
the underlying data, even when applied to a remote data source.)
}
\examples{
glimpse(mtcars)

if (require("RSQLite") && has_lahman("sqlite")) {
  batting <- tbl(lahman_sqlite(), "Batting")
  glimpse(batting)
}
}

