% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jade.R
\name{jade}
\alias{jade}
\title{Discriminative parameter learning of BN by JADE.}
\usage{
jade(
  NP = 40,
  G = 100,
  data,
  class.name,
  c = 0.1,
  structure = c("nb", "tancl", "hc"),
  pB = 0.05,
  edgelist = NULL,
  archive = TRUE,
  verbose = 25,
  ...
)
}
\arguments{
\item{NP}{positive integer giving the number of candidate solutions in the initial population.}

\item{G}{positive integer specifying the maximum number of generations that may be performed before the algorithm is halted.}

\item{data}{The data frame from which to learn the classifier.}

\item{class.name}{A character. Name of the class variable.}

\item{c}{A numeric. An adaptation parameter. Default is 0.1.}

\item{structure}{A character. Name of the structure learning function. "tan" uses Tree Augmented Network.
"nb" uses Naive Bayes. "hc" uses Hill Climbing.}

\item{pB}{A numeric. JADE mutation strategy.}

\item{edgelist}{A matrix. An optional edge list to use a custom BN structure
that will replace de learned structure.}

\item{archive}{A logical. If TRUE, trial vector r2 is randomly selected from the union of
the current population and the external archive.}

\item{verbose}{positive integer indicating the number of generations until the iteration progress should be printed.}

\item{...}{other structure learning options from \link[bnclassify]{tan_cl} or \link[bnclassify]{tan_hc}.}
}
\value{
An object of class \code{DE}, which is a list with the following components:
\item{Best}{A \code{bnc_bn} object with the best individual in the final population, i.e., the bayesian network with the best fitness at the end of evolution.}
\item{BestCLL}{A numeric specifying the Conditional Log-Likelihood of the best individual.}
\item{pobFinal}{A list of \code{bnc_bn} objects with the final population, i.e., a set of bayesian networks with optimized parameters at the end of evolution.}
\item{CLLPobFinal}{A numeric vector specifying the Conditional Log-Likelihood of the final population.}
\item{N.evals}{An integer giving the total number of evaluations.}
\item{convergence}{A numeric vector giving the maximum Conditional Log-Likelihood at each generation.}
\item{evaluations}{An integer vector giving the total number of evaluations at each generation.}
}
\description{
Learn parameters of a Bayesian Network in a discriminative way
by Adaptive Differential Evolution with optional external Archive
}
\examples{
# Load data
data(car)
# Parameter learning with "JADE with Archive" variant, and structure with
# hill-climbing algorithm, so argument "k" must be provided.
dpl.jade <- jade(NP=40, G=50, data = car, class.name = names(car)[7], c = 0.1,
structure = "hc", pB=0.05, edgelist = NULL, archive = TRUE, verbose = 5, k = 3)
# Print results
print(dpl.jade)
\dontrun{plot(dpl.jade)}
}
