% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{dpcr-class}
\alias{dpcr}
\alias{dpcr-class}
\title{Class \code{"dpcr"} - general digital PCR}
\description{
A class containing results of any digital PCR experiment. 
Type of data in all columns is specified in slot \code{"type"}.
}
\details{
Possible \code{type} values of \code{dpcr} objects:
\enumerate{
 \item{\code{"ct"}: cycle threshold of each partition,}
 \item{\code{"fluo"}: fluorescence of each partition,}
 \item{\code{"nm"}: number of molecules in each partition,}
 \item{\code{"np"}: status (positive (1) or negative(0)) of each partition,}
 \item{\code{"tnp"}: total number of positive partitions in the run (single 
 value per each run, not per partition).}}
 
Digital PCR data is always a matrix, where columns and rows represent 
respectively runs and data points. For example, matrix with 2 columns and 765 rows
means two runs with 765 data points each. In case of \code{"tnp"} data, each run is
represented by only one measurement, the count of all positive partitions.

The number of partitions is defined in slot \code{n}. In the previous example, 
two runs have 765 data points, but they can have less detected partitions 
(for example some reads may be not available). In this case, the data point will 
have value NA. 

The structure of \code{dpcr} class is described more deeply in the vignette.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\code{matrix} data from digital PCR experiments. See Details.}

\item{\code{n}}{\code{integer} equal to the number of partitions in each run.}

\item{\code{exper}}{\code{factor} the id or name of experiments.}

\item{\code{replicate}}{\code{factor} the id or name of replicates.}

\item{\code{assay}}{\code{factor} the id or name of the assay.}

\item{\code{v}}{\code{"numeric"} volume of the partition [nL].}

\item{\code{uv}}{\code{"numeric"} uncertainty of the volume of the partition [nL].}

\item{\code{threshold}}{\code{"numeric"} value specifying the threshold. Partition with 
the value equal or bigger than threshold are considered positive.}

\item{\code{type}}{Object of class \code{"character"} defining type of data. See Details.}
}}
\note{
This class represent the most general droplet-based digital PCR. In more specific 
cases, the user is directed to other classes: \code{\linkS4class{adpcr}}, where 
results can be placed over a plate, \code{\linkS4class{qdpcr}} where digital 
assay is based on multiple qPCR experiments and \code{\linkS4class{rtadpcr}},
where data points represent the status of partitions measured in the 
real time.
}
\examples{

dpcr_fluo <- sim_dpcr(m = 10, n = 20, times = 5, fluo = list(0.1, 0))
plot(dpcr_fluo)

dpcr <- sim_dpcr(m = 10, n = 20, times = 5)
}
\author{
Michal Burdukiewicz.
}
\keyword{classes}

