% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_pooled.R
\name{analyze_pooled}
\alias{analyze_pooled}
\title{Pooled digital PCR analysis}
\usage{
analyze_pooled(input, v, conf.level = 0.05)
}
\arguments{
\item{input}{object of class \code{\linkS4class{adpcr}} or \code{\linkS4class{ddpcr}}.}

\item{v}{volume (microliters).}

\item{conf.level}{confidence level of the intervals and groups.}
}
\value{
data frame with the number of rows equal to the number of replicates.
}
\description{
Estimates mean number of template molecules per partition and concentration of sample 
from pooled replicates of experiments.
}
\note{
This function was implemented using the code in supplemental materials in 
Dorazio, 2015 (see References).
}
\author{
Robert M. Dorazio, Margaret E. Hunter.
}
\references{
Dorazio RM, Hunter ME, \emph{Statistical Models for the Analysis 
and Design of Digital Polymerase Chain Reaction (dPCR) Experiments}. 
Analytical Chemistry 2015. 87(21): p.10886-10893
}

