% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_this}
\alias{download_this}
\title{Download button}
\usage{
download_this(
  .data,
  output_name,
  output_extension = c(".csv", ".xlsx"),
  button_label = "Download data",
  button_type = c("default", "primary", "success", "info", "warning", "danger"),
  has_icon = TRUE,
  icon = "fa fa-save",
  ...
)
}
\arguments{
\item{.data}{A data frame to write to disk.}

\item{output_name}{Name of of the output file.}

\item{output_extension}{Extension of the output file. Currently, only  \code{.csv} and  \code{.xlsx} are supported.}

\item{button_label}{character (HTML), button label}

\item{button_type}{character, one of the standard Bootstrap types}

\item{has_icon}{specify whether to include fontawesome icons in the button label}

\item{icon}{fontawesome tag e.g.: "fa fa-save"}

\item{...}{attributes (named arguments) and children (unnamed arguments)
of the button, passed to \code{htmltools::\link[htmltools]{tag}}}
}
\value{
\code{htmltools::\link[htmltools]{tag}}, \code{<button/>}
}
\description{
Wrapper around \code{bsplus::\link[bsplus]{bs_button}} to provide a download button for HTML outputs in R Markdown.
Internally, the function writes the file to `tempdir()`, encodes it, and produces the download button.
}
\section{Warning}{

This example will write the `mtcars` dataset to `tempdir()` and produce the download button for the file `mtcars dataset.csv` with the `fa fa-save` icon on the `Download data` label.
}

\examples{
mtcars \%>\%
  download_this(
    output_name = "mtcars dataset",
    output_extension = ".csv",
    button_label = "Download data",
    button_type = "warning",
    has_icon = TRUE,
    icon = "fa fa-save"
  )
}
