% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{grl}
\alias{grl}
\title{Approximating effective-counts as proposed by Greenland & Longnecker}
\usage{
grl(y, v, cases, n, type, data, tol = 1e-05)
}
\arguments{
\item{y}{a vector, defining the (reported) log relative risks.}

\item{v}{a vector, defining the variances of the reported log relative risks.}

\item{cases}{a vector, defining the number of cases for each exposure level.}

\item{n}{a vector, defining the total number of subjects for each exposure level. For incidence-rate data \code{n} indicates the amount of person-time within 
each exposure level.}

\item{type}{a vector (or a character string), specifying the design of the study. Options are
\code{cc}, \code{ir}, and \code{ci}, for case-control, incidence-rate, and cumulative incidence data, respectively.}

\item{data}{an optional data frame (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the previous arguments.}

\item{tol}{define the tolerance.}
}
\value{
The results are returned structured in a matrix
\tabular{ll}{
\code{A} \tab approximated number of effective cases. \cr
\code{N} \tab approximated total number of effective subjects. \cr
}
}
\description{
Reconstructs the set of pseudo-numbers (or 'effective' numbers) of cases and non-cases consistent
with the input data (log relative risks). The method was first proposed in 1992 by Greenland and Longnecker.
}
\details{
The function reconstructs the effective counts corresponding to the multivariable adjusted log relative risks as well as their standard errors. 
A unique solution is guaranteed by keeping the margins of the table of pseudo-counts equal to the margins of the crude or unadjusted data 
(Greenland and Longnecker 1992). See the referenced article for a complete description of the algorithm implementation.
}
\examples{
## Loading data
data("alcohol_cvd")

## Obtaining pseudo-counts for the first study (id = 1)
grl(y = logrr, v = I(se^2), cases = cases, n = n, type = type,
   data = subset(alcohol_cvd, id == 1))
   
## Obtaining pseudo-counts for all study
by(alcohol_cvd, alcohol_cvd$id, function(x)
   grl(y = logrr, v = I(se^2), cases = cases, n = n, type = type, data = x))

## Restructuring the previous results in a matrix
do.call("rbind", by(alcohol_cvd, alcohol_cvd$id, function(x)
   grl(y = logrr, v = I(se^2), cases = cases, n = n, type = type, data = x)))

}
\references{
Greenland, S., Longnecker, M. P. (1992). Methods for trend estimation from summarized dose-response data, with applications to meta-analysis. American journal of epidemiology, 135(11), 1301-1309.

Orsini, N., Li, R., Wolk, A., Khudyakov, P., Spiegelman, D. (2012). Meta-analysis for linear and nonlinear dose-response relations: examples, an evaluation of approximations, and software. 
American journal of epidemiology, 175(1), 66-73.
}
\seealso{
\code{\link{covar.logrr}}, \code{\link{hamling}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
