% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{remi}
\alias{remi}
\title{DOREMI first order analysis function}
\usage{
remi(data, id = NULL, input = NULL, time = NULL, signal,
  embedding = 2, verbose = FALSE)
}
\arguments{
\item{data}{Is a data frame containing at least one column, that is the signal to be analyzed.}

\item{id}{Is a STRING containing the NAME of the column of data containing the identifier of the individual.
If this parameter is not entered when calling the function, a single individual is assumed and a linear regression is done instead
of the linear mixed-effects regression.}

\item{input}{Is a STRING or a VECTOR OF STRINGS containing the NAME(s) of data column(s) containing the EXCITATION vector(s).
If this parameter is not entered when calling the function,
the excitation is assumed to be unknown. In this case, the linear mixed-effect regression is still carried out but no coefficient is calculated
for the excitation term. The function then uses the parameters estimated by the regression to carry out an exponential fit of the signal
and build the estimated curve.
The function will consider an excitation variable each column of data whose name is contained in the input vector.
The function will return a coefficient for each one of the excitation variables included.}

\item{time}{Is a STRING containing the NAME of the column of data containing the time vector. If this parameter is not entered when calling the function,
it is assumed that time steps are of 1 unit and the time vector is generated internally in the function.}

\item{signal}{Is a STRING containing the NAME of the column of the data frame containing the SIGNAL to be studied.}

\item{embedding}{Is a positive integer containing the number of points to be used for the calculation of the derivatives. Its value by default is 2 as at
least two points are needed for the calculation of the first derivative.}

\item{verbose}{Is a boolean that displays status messages of the function when set to 1.}
}
\value{
Returns a summary of the fixed components for the three coefficients: damping time, excitation coefficient and equilibrium value.
}
\description{
\code{remi}  estimates the coefficients of a first order differential equation of the form:
\deqn{\frac{1}{\gamma} \dot{y}(t) = - y(t) + \epsilon E(t) + eqvalue}
using linear mixed-effect models.
Where y(t) is the individual's signal, \eqn{\dot{y}(t)} is the derivative and E(t) is the excitation.
}
\details{
The analysis performs the following linear mixed-effects regression:
\deqn{y_{ij}'  \sim   b_{0} +b_{0j}+b_{1} y_{ij}+b_{2} E_{ij}+u_{1j} y_{ij}+u_{2j} E_{ij}+e_{ij}}
with i accounting for the time and j for the different individuals. \eqn{e_{ij}} are the residuals,
\eqn{y_{ij}'} is the derivative calculated on embedding points and
y and E are the signal and the excitation averaged on embedding points.
The coefficients estimated to characterize the signal are calculated as follows:
\itemize{
  \item Damping time:  \eqn{\tau _{j} =  \frac{1}{ \gamma _{j} }}  with \eqn{\gamma _{j} =  b_{1} + u_{1j} }
  \item Excitation coefficient: \eqn{\epsilon _{j} = \frac{b_{2} + u_{2j}}{\gamma _{j}}}. It is the proportionality between the excitation and the
  difference between the maximum value reached by the signal and its initial value.
  \item Equilibrium value: \eqn{eqvalue _{j} = \frac{b_{0} + b_{0j}}{\gamma _{j}}}. It is the stable value reached in the absence of excitation.
}
The estimation is performed using the function lmer if there are several individuals or lm if there is only one.
With the above estimated parameters, the estimated signal can be reconstructed for
each individual by first performing the convolution of the excitation with the Green function using the estimated damping rate
and then offsetting the resulting signal with the equilibrium value.
The function returns five objects:
\enumerate{
 \item data- A data.frame including the input data and intermediate calculations used to prepare the variables for
  the fit:

    signal_rollmean - calculation of the moving average of the signal over embedding points.

    signal_derivate1 - calculation of the first derivative of the signal with the GOLD method in embedding points.

    time_derivate - calculation of the moving average of the time vector over embedding points.

    input_rollmean - calculation of the moving average of the excitation vector over embedding points.
 \item resultid- A data.frame including for each individual, listed by id number, the damping time, the excitation coefficient and the
 equilibrium value (see variables presented in the Details section).
 \item resultmean- A data.frame including the fixed effects of the three coefficients mentioned above.
 \item regression- A list containing the summary of the linear mixed-effects regression.
 \item estimated- A data.frame containing the estimated signal calculated as the convolution of the Green function with the
 estimated damping time, excitation coefficient and equilibrium value and the excitation
 vector with an added offset (see above). There are two extreme cases in the generation of the signal and these depend on sampling. The excitation
 vector is expanded to generate a pseudo-continuous signal and increase accuracy when calculating the convolution. Missing data in the exitation signal
 is completed by using the previous known value (exc_min in the data.frame) or using the next known value
 (exc_max in the data.frame). With these two imputed excitation vectors, the two extreme cases of the
 mean estimated signal are calculated by carrying out the convolution between the Green function (decreasing exponential with the damping time calculated by
 the linear mixed-effects regression). These excitation variables are then used to generate the ymin and ymax signals respectively.

 As seen in the Description section, the print method by default prints only the resultmean element. Each one of the other objects
 can be accessed by indicating $ and their name after the result, for instance, for a DOREMI object called "result", it is possible
 to access the regression summary by typing result$regression.
 \item embedding - contains the embedding number used to generate the results (same as function input argument)
}
}
\examples{
myresult <- remi(data = cardio,
                 id = "id",
                 input = "load",
                 time = "time",
                 signal = "hr",
                 embedding = 5)
}
\seealso{
\code{\link{calculate.gold}} to compute the derivatives, for details on embedding.
}
\keyword{analysis,}
\keyword{exponential}
\keyword{first}
\keyword{order,}
