% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{inclin}
\alias{inclin}
\title{inclin}
\usage{
inclin(mesh)
}
\arguments{
\item{mesh}{object of class mesh3d}
}
\value{
A numeric vector of inclination values for all the polygons of the mesh.
}
\description{
Compute inclination i.e. the angle between triangles and the vertical plane in degrees, comprised
between 0 and 180.
}
\examples{
inclin <- inclin(dkmodel$cusp)
summary(inclin)

#render on a map:
dkmap(dkmodel$cusp, inclin, col = "inclin",
min.range = 0, max.range = 180, legend = TRUE)
}
\references{
\doi{10.1371/journal.pone.0066142}{Guy et al. (2013)}
}
\seealso{
\code{\link{slope}}
}
