% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists-categorical.R
\name{dodgr_dists_categorical}
\alias{dodgr_dists_categorical}
\title{Cumulative distances along different edge categories}
\usage{
dodgr_dists_categorical(
  graph,
  from = NULL,
  to = NULL,
  proportions_only = FALSE,
  dlimit = NULL,
  heap = "BHeap",
  quiet = TRUE
)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph which must have a column named "edge_type" which labels categories of
edge types along which categorical distances are to be aggregated (see
Note).}

\item{from}{Vector or matrix of points \strong{from} which route distances are to
be calculated (see Notes)}

\item{to}{Vector or matrix of points \strong{to} which route distances are to be
calculated (see Notes)}

\item{proportions_only}{If \code{FALSE}, return distance matrices for full
distances and for each edge category; if \code{TRUE}, return single vector of
proportional distances, like the \code{summary} function applied to full
results. See Note.}

\item{dlimit}{If \code{TRUE}, and no value to \code{to} is given, distances are
aggregated from each \code{from} point out to the specified distance limit (in
the same units as the edge distances of the input graph). The
\code{proportions_only} argument has no effect when \code{dlimit = TRUE}.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\verb{Trinomial Heap (}TriHeap\verb{), Extended Trinomial Heap (}TriHeapExt\verb{, and 2-3 Heap (}Heap23`).}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
If \code{dlimit = FALSE}, a list of distance matrices of equal dimensions
(length(from), length(to)), the first of which ("distance") holds the final
distances, while the rest are one matrix for each unique value of
"edge_type", holding the distances traversed along those types of edges only.
If \code{dlimit = TRUE}, a single matrix of total distances along all ways from
each point, along with distances along each of the different kinds of ways
specified in the "edge_type" column of the input graph.
}
\description{
Cumulative distances along different edge categories
}
\note{
The "edge_type" column in the graph can contain any kind of discrete or
categorical values, although integer values of 0 are not permissible. \code{NA}
values are ignored. The function requires one full distance
matrix to be stored for each category of "edge_type" (unless
\code{proportions_only = TRUE}). It is wise to keep numbers of discrete types as
low as possible, especially for large distance matrices.

Setting the \code{proportions_only} flag to \code{TRUE} may be advantageous for
large jobs, because this avoids construction of the full matrices. This may
speed up calculations, but perhaps more importantly it may make possible
calculations which would otherwise require distance matrices too large to be
directly stored.
}
\seealso{
Other distances: 
\code{\link{dodgr_distances}()},
\code{\link{dodgr_dists}()},
\code{\link{dodgr_flows_aggregate}()},
\code{\link{dodgr_flows_disperse}()},
\code{\link{dodgr_flows_si}()},
\code{\link{dodgr_isochrones}()},
\code{\link{dodgr_isodists}()},
\code{\link{dodgr_isoverts}()},
\code{\link{dodgr_paths}()},
\code{\link{dodgr_times}()}
}
\concept{distances}
