% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nint.R
\name{nint_transform}
\alias{nint_transform}
\title{Transform Integral}
\usage{
nint_transform(f, space, dIdcs, trans, infZero = 0)
}
\arguments{
\item{f}{\code{function(x, ...)}, the integrand.}

\item{space}{some space.}

\item{dIdcs}{an integer vector of indices, the dimensions to transform.}

\item{trans}{either the name of some builtin transformation or \code{list(g=function(x), gij=function(y))} where \code{g(x) = y} and \code{gij} evaluates to the column matrix of \code{gi(y) = x} and its first derivative with respect to \code{y}.}

\item{infZero}{the value to return if the jacobian is infinite and \code{f} returns \code{0}.}
}
\value{
\code{nint_transform} returns a named list containing the transformed integrand and space.
}
\description{
\code{nint_transform} applies monotonic transformations to some integrand and space.
A common use case is to apply the probability integral transform, or to transform infinite limits to finite ones.
}
\details{
If the transformation is vector valued, that is \code{y = c(y1, ..., yn) = g(c(x1, ..., xn))}, then each component of \code{y} shall exclusively depend on the corresponding component of \code{x}.
So \code{y[i] = g[i](x[i])} for some implicit function \code{g[i]}.

Builtins: \itemize{
\item tan: \code{g(x) = atan(x) = y}
\item ratio: \code{g(x) = x/abs(x + sign(x))} = y with \code{sign(0) == 1}
}
}
\examples{
## builtins
f = sin
s = nint_space(nint_intvDim(pi/4, 3*pi/4))
nint_integrate(f, s)

tt = nint_transform(f, s, 1, 'tan')
tt$space
nint_integrate(tt$f, tt$space)

tt = nint_transform(f, s, 1, 'ratio')
tt$space
nint_integrate(tt$f, tt$space)


## probability integral transform
tt = nint_transform(f, s, 1, list(
    g=pnorm,
    gij=function(x) { t1 = qnorm(x); cbind(t1, 1/dnorm(t1)) })
)
tt$space
nint_integrate(tt$f, tt$space)


## infinite limitis
f = function(x) prod(1/(1 + x**2))
s = nint_space(nint_intvDim(-1, Inf),
               nint_intvDim(-Inf, Inf))
s

nint_integrate(f, s) # stats::integrate takes care of Inf limits

tt = nint_transform(f, s, 1:2, 'tan')
tt$space
nint_integrate(tt$f, tt$space)

tt = nint_transform(f, s, 1:2, 'ratio')
tt$space
nint_integrate(tt$f, tt$space)

## probability integral transform
tt = nint_transform(f, s, 1:2, list(
    g=pnorm,
    gij=function(x) { t1 = qnorm(x); cbind(t1, 1/dnorm(t1)) })
)
tt$space
#nint_integrate(tt$f, tt$space) # Do you dare?

## The probability integral transform was used many times with fisherI,
## always with great success and considerable gains.
## It might be stats::integrate; see nint_integrateNCube
}
\seealso{
\code{\link{nint_integrate}}, \code{\link{nint_space}}, \code{\link{fisherI}}
}

