% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx2pdf.R
\name{docx2pdf}
\alias{docx2pdf}
\title{Convert docx to pdf}
\usage{
docx2pdf(input, output = gsub("\\\\.docx$", ".pdf", input))
}
\arguments{
\item{input, output}{file input and optional file output (default
to input with pdf extension).}
}
\value{
the name of the produced pdf (the same value as \code{output})
}
\description{
Convert docx to pdf directly using "Microsoft Word".
This function will not work if "Microsoft Word" is not available
on your machine.

On Windows, this is implemented via win32com while on macOS this is
implemented via JXA (Javascript for Automation, aka AppleScript in JS).

This is a simple call to python module 'docx2pdf'.
}
\examples{
library(locatexec)
if (exec_available('python') && docx2pdf_available()) {
  file <- system.file(package = "doconv",
    "doc-examples/example.docx")

  out <- docx2pdf(input = file,
    output = tempfile(fileext = ".pdf"))

  if (file.exists(out)) {
    message(basename(out), " is existing now.")
  }
}
}
\seealso{
Other tools for docx2pdf: 
\code{\link{docx2pdf_available}()},
\code{\link{docx2pdf_install}()},
\code{\link{docx2pdf_uninstall}()}
}
\concept{tools for docx2pdf}
