% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_state.R
\name{get_dock}
\alias{get_dock}
\alias{get_panels}
\alias{get_panels_ids}
\alias{get_active_group}
\alias{get_grid}
\alias{get_groups}
\alias{get_groups_ids}
\alias{get_groups_panels}
\alias{save_dock}
\alias{restore_dock}
\title{get dock}
\usage{
get_dock(dock_id, session = getDefaultReactiveDomain())

get_panels(dock_id, session = getDefaultReactiveDomain())

get_panels_ids(dock_id, session = getDefaultReactiveDomain())

get_active_group(dock_id, session = getDefaultReactiveDomain())

get_grid(dock_id, session = getDefaultReactiveDomain())

get_groups(dock_id, session = getDefaultReactiveDomain())

get_groups_ids(dock_id, session = getDefaultReactiveDomain())

get_groups_panels(dock_id, session = getDefaultReactiveDomain())

save_dock(dock_id, session = getDefaultReactiveDomain())

restore_dock(dock_id, data, session = getDefaultReactiveDomain())
}
\arguments{
\item{dock_id}{Dock unique id. When using modules the namespace is
automatically added.}

\item{session}{shiny session object.}

\item{data}{Data representing a serialised dock object.}
}
\value{
\code{get_dock} returns a list of 3 elements:
\itemize{
\item grid: a list representing the dock layout.
\item panels: a list having the same structure as \code{\link[=panel]{panel()}} composing the dock.
\item activeGroup: the current active group (a string).
}

Each other function allows to deep dive into the returned
value of \code{\link[=get_dock]{get_dock()}}.
\code{\link[=get_panels]{get_panels()}} returns the \code{panels} element of \code{\link[=get_dock]{get_dock()}}.
\code{\link[=get_panels_ids]{get_panels_ids()}} returns a character vector containing all panel ids
from \code{\link[=get_panels]{get_panels()}}.
\code{\link[=get_active_group]{get_active_group()}} extracts the \code{activeGroup} component of
\code{\link[=get_dock]{get_dock()}} as a string.
\code{\link[=get_grid]{get_grid()}} returns the \code{grid} element of \code{\link[=get_dock]{get_dock()}} which is a list.
\code{\link[=get_groups]{get_groups()}} returns a list of panel groups from \code{\link[=get_grid]{get_grid()}}.
\code{\link[=get_groups_ids]{get_groups_ids()}} returns a character vector of groups ids
from \code{\link[=get_groups]{get_groups()}}.
\code{\link[=get_groups_panels]{get_groups_panels()}} returns a list of character vector containing
the ids of each panel within each group.
\code{\link[=save_dock]{save_dock()}} and \code{\link[=restore_dock]{restore_dock()}} are used for their side effect to
allow to respectively serialise and restore a dock object.
}
\description{
get dock

get dock panels

get dock panels ids

get dock active group

get dock grid

get dock groups

get dock groups ids

get dock groups panels

save a dock

restore a dock
}
\note{
Only works with server side functions like \link{add_panel}.
Don't call it from the UI.
}
