% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc2concrete.R
\name{doc2concrete}
\alias{doc2concrete}
\title{Concreteness Scores}
\usage{
doc2concrete(
  texts,
  domain = c("open", "advice", "plans"),
  wordlist = NULL,
  stop.words = TRUE,
  number.words = TRUE,
  shrink = FALSE,
  fill = FALSE,
  num.mc.cores = 1
)
}
\arguments{
\item{texts}{character A vector of texts, each of which will be tallied for concreteness.}

\item{domain}{character Indicates the domain from which the text data was collected (see details).}

\item{wordlist}{Dictionary to be used. Default is the Brysbaert et al. (2014) list.}

\item{stop.words}{logical Should stop words be kept? Default is TRUE}

\item{number.words}{logical Should numbers be converted to words? Default is TRUE}

\item{shrink}{logical Should open-domain concreteness models regularize low-count words? Default is FALSE.}

\item{fill}{logical Should empty cells be assigned the mean rating? Default is TRUE.}

\item{num.mc.cores}{numeric number of cores for parallel processing - see parallel::detectCores(). Default is 1.}
}
\value{
A vector of concreteness scores, with one value for every item in `text`.
}
\description{
Detects linguistic markers of concreteness in natural language.
    This function is the workhorse of the \code{doc2concrete} package, taking a vector of text documents and returning an equal-length vector of concreteness scores.
}
\details{
In principle, concreteness could be measured from any english text. However, the
definition and interpretation of concreteness may vary based on the domain. Here, we provide
a domain-specific pre-trained classifier for concreteness in advice & feedback data, which we have
empirically confirmed to be robust across a variety of contexts within that domain (Yeomans, 2020).

There are many domains where such pre-training is not yet possible. Accordingly, we provide
support for two off-the-shelf concreteness "dictionaries" - i.e. document-level aggregations of
word-level scores. We found that that have modest (but consistent) accuracy across domains and contexts.
However, we still encourage researchers to train a model of concreteness in their own domain, if possible.
}
\examples{


data("feedback_dat")

doc2concrete(feedback_dat$feedback, domain="open")


cor(doc2concrete(feedback_dat$feedback, domain="open"),feedback_dat$concrete)


}
\references{
Yeomans, M. (2020). Concreteness, Concretely. Working Paper.

Brysbaert, M., Warriner, A. B., & Kuperman, V. (2014). Concreteness ratings for 40 thousand generally known English word lemmas. Behavior Research Methods, 46(3), 904-911.

Paetzold, G., & Specia, L. (2016, June). Inferring psycholinguistic properties of words. In Proceedings of the 2016 Conference of the North American Chapter of the Association for Computational Linguistics: Human Language Technologies (pp. 435-440).
}
