% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BY-splitBy2.R
\name{by-split}
\alias{by-split}
\alias{splitBy}
\title{Split a data frame}
\usage{
splitBy(formula, data = parent.frame(), drop = TRUE)
}
\arguments{
\item{formula}{Variables to split data frame by, as ‘as.quoted’ variables,
a formula or character vector.}

\item{data}{A data frame}

\item{drop}{Logical indicating if levels that do not occur should be
dropped. Deprecated; levels that do not occur are ignored.}
}
\value{
A list of dataframes.
}
\description{
Split a dataframe according to the levels of variables
    in the dataframe. The variables to split by can be given as a
    formula or as a character vector.
}
\examples{

data(dietox, package="doBy")
splitBy(formula = ~Evit + Cu, data = dietox)
splitBy(formula = c("Evit", "Cu"), data = dietox)

splitBy(~Month, data=airquality)
splitBy("Month", data=airquality)
}
\seealso{
\code{\link{orderBy}}, \code{\link{summaryBy}},
    \code{\link{transformBy}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
