% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_toWide.R
\name{reshape_toWide}
\alias{reshape_toWide}
\title{Convert Long Data to Wide}
\usage{
reshape_toWide(data, id, prefix, suffix, j)
}
\arguments{
\item{data}{long data}

\item{id}{can be one or more. If id is missing, row numbers will be treated as id}

\item{prefix}{prefix of value variables}

\item{suffix}{suffix of value variables}

\item{j}{the name of operated column}
}
\value{
wide data
}
\description{
Convert long data to wide.
}
\examples{
df = data.frame(id = c(1,1,2,2,3,3,4,4),
                time = c(1,2,1,2,1,2,1,2),
                w = c(1,6,2,7,3,8,4,9),
                h = c(5,1,6,3,7,5,8,7),
                n = c(2,2,3,3,4,4,5,5))

# prefix
reshape_toWide(data = df,
               id='m',
               prefix = c('w','h'),
               j = 'time')

# suffix
reshape_toWide(data = df,
               id='m',
               suffix = c('w','h'),
               j = 'time')
}
