% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{run_clr}
\alias{run_clr}
\title{Wrapper for CLR method}
\usage{
run_clr(x, estimator = "spearman", ...)
}
\arguments{
\item{x}{A n by p matrix of gene expression data (n samples and p genes).}

\item{estimator}{Argument is passed into \code{\link[minet]{build.mim}}.}

\item{...}{Additional arguments are ignored.}
}
\value{
A p by p matrix of association scores.
}
\description{
Conducts co-expression analysis using CLR \insertCite{faith07}{dnapath}.
Uses the implementation from the \code{minet} package \insertCite{meyer08}{dnapath}.
Can be used for the \code{network_inference} argument in \code{\link{dnapath}}.
}
\examples{
data(meso)
data(p53_pathways)

# To create a short example, we subset on two pathways from the p53 pathway list,
# and will only run 5 permutations for significance testing.
pathway_list <- p53_pathways[c(8, 13)]
n_perm <- 5

# Use this method to perform differential network analysis.
# The parameters in run_clr() can be adjusted using the ... argument.
# For example, the 'estimator' paramter can be specified as shown here.
results <- dnapath(x = meso$gene_expression,
                   pathway_list = pathway_list,
                   groups = meso$groups,
                   n_perm = n_perm,
                   network_inference = run_clr,
                   estimator = "spearman")
summary(results)

# The group-specific association matrices can be extracted using get_networks().
nw_list <- get_networks(results[[1]]) # Get networks for pathway 1.

\donttest{
# nw_list has length 2 and contains the inferred networks for the two groups.
# The gene names are the Entrezgene IDs from the original expression dataset.
# Renaming the genes in the dnapath results to rename those in the networks.
# NOTE: The temporary directory, tempdir(), is used in this example. In practice,
#       this argument can be removed or changed to an existing directory
results <- rename_genes(results, to = "symbol", species = "human",
                        dir_save = tempdir())
nw_list <- get_networks(results[[1]]) # The genes (columns) will have new names.

# (Optional) Plot the network using SeqNet package (based on igraph plotting).
# First rename entrezgene IDs into gene symbols.
SeqNet::plot_network(nw_list[[1]])
}
}
\references{
\insertRef{faith07}{dnapath}

\insertRef{meyer08}{dnapath}
}
\seealso{
\code{\link{run_aracne}},
\code{\link{run_bc3net}}, \code{\link{run_c3net}}, \code{\link{run_corr}},
\code{\link{run_dwlasso}}, \code{\link{run_genie3}},
\code{\link{run_glasso}}, \code{\link{run_mrnet}},
\code{\link{run_pcor}}, and \code{\link{run_silencer}}
}
