% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{run_bc3net}
\alias{run_bc3net}
\title{Wrapper for BC3Net method}
\usage{
run_bc3net(
  x,
  boot = 100,
  estimator = "spearman",
  disc = "equalwidth",
  mtc1 = TRUE,
  adj1 = "bonferroni",
  alpha1 = 0.05,
  mtc2 = TRUE,
  adj2 = "bonferroni",
  alpha2 = 0.05,
  ...
)
}
\arguments{
\item{x}{A n by p matrix of gene expression data (n samples and p genes).}

\item{boot}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{estimator}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{disc}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{mtc1}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{adj1}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{alpha1}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{mtc2}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{adj2}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{alpha2}{Argument is passed into \code{\link[bc3net]{bc3net}}.}

\item{...}{Additional arguments are ignored.}
}
\value{
A p by p matrix of association scores.
}
\description{
Conducts co-expression analysis using BC3Net \insertCite{matos12}{dnapath}.
Uses the implementation from the \code{bc3net} package \insertCite{bc3net}{dnapath}.
Can be used for the \code{network_inference} argument in \code{\link{dnapath}}.
}
\examples{
data(meso)
data(p53_pathways)

# To create a short example, we subset on one pathway from the p53 pathway list,
# and will only run 1 permutation for significance testing.
pathway_list <- p53_pathways[13]
n_perm <- 1

# Use this method to perform differential network analysis.
# The parameters in run_bc3net() can be adjusted using the ... argument.
# For example, the 'estimator' and 'boot' parameter can be specified as shown here.
results <- dnapath(x = meso$gene_expression,
                   pathway_list = pathway_list,
                   groups = meso$groups,
                   n_perm = n_perm,
                   network_inference = run_bc3net,
                   boot = 10,
                   estimator = "pearson",
                   mtc1 = FALSE,
                   mtc2 = FALSE)
summary(results)

# The group-specific association matrices can be extracted using get_networks().
nw_list <- get_networks(results) # Get networks for pathway 1.

\donttest{
# nw_list has length 2 and contains the inferred networks for the two groups.
# The gene names are the Entrezgene IDs from the original expression dataset.
# Renaming the genes in the dnapath results to rename those in the networks.
# NOTE: The temporary directory, tempdir(), is used in this example. In practice,
#       this argument can be removed or changed to an existing directory
results <- rename_genes(results, to = "symbol", species = "human",
                        dir_save = tempdir())
nw_list <- get_networks(results) # The genes (columns) will have new names.

# (Optional) Plot the network using SeqNet package (based on igraph plotting).
# First rename entrezgene IDs into gene symbols.
SeqNet::plot_network(nw_list[[1]])
}
}
\references{
\insertRef{matos12}{dnapath}

\insertRef{bc3net}{dnapath}
}
\seealso{
\code{\link{run_aracne}}, \code{\link{run_c3net}},
\code{\link{run_clr}}, \code{\link{run_corr}},
\code{\link{run_dwlasso}}, \code{\link{run_genie3}},
\code{\link{run_glasso}}, \code{\link{run_mrnet}},
\code{\link{run_pcor}}, and \code{\link{run_silencer}}
}
