% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\name{initialize,dmbc_fit-method}
\alias{initialize,dmbc_fit-method}
\alias{dmbc_fit-initialize}
\title{Create an instance of the \code{dmbc_fit} class using new/initialize.}
\usage{
\S4method{initialize}{dmbc_fit}(
  .Object,
  z.chain = array(),
  z.chain.p = array(),
  alpha.chain = matrix(),
  eta.chain = matrix(),
  sigma2.chain = matrix(),
  lambda.chain = matrix(),
  prob.chain = array(),
  x.ind.chain = array(),
  x.chain = matrix(),
  accept = matrix(),
  diss = list(),
  dens = list(),
  control = list(),
  prior = list(),
  dim = list(),
  model = NA
)
}
\arguments{
\item{.Object}{Prototype object from the class \code{\link{dmbc_fit}}.}

\item{z.chain}{An object of class \code{array}; posterior draws from
the MCMC algorithm for the (untransformed) latent configuration \eqn{Z}.}

\item{z.chain.p}{An object of class \code{array}; posterior draws from
the MCMC algorithm for the (Procrustes-transformed) latent configuration
\eqn{Z}.}

\item{alpha.chain}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\alpha} parameters.}

\item{eta.chain}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\eta} parameters.}

\item{sigma2.chain}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\sigma^2} parameters.}

\item{lambda.chain}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\lambda} parameters.}

\item{prob.chain}{An object of class \code{array}; posterior draws
from the MCMC algorithm for the cluster membership probabilities.}

\item{x.ind.chain}{An object of class \code{array}; posterior draws
from the MCMC algorithm for the cluster membership indicators.}

\item{x.chain}{An object of class \code{matrix}; posterior draws from
the MCMC algorithm for the cluster membership labels.}

\item{accept}{An object of class \code{matrix}; final acceptance rates
for the MCMC algorithm.}

\item{diss}{An object of class \code{list}; list of observed
dissimilarity matrices.}

\item{dens}{An object of class \code{list}; list of log-likelihood,
log-prior and log-posterior values at each iteration of the MCMC simulation.}

\item{control}{An object of class \code{list}; list of the control
parameters (number of burnin and sample iterations, number of MCMC chains,
etc.). See \code{\link{dmbc_control}()} for more information.}

\item{prior}{An object of class \code{list}; list of the prior
hyperparameters. See \code{\link{dmbc_prior}()} for more information.}

\item{dim}{An object of class \code{list}; list of dimensions for
the estimated model, i.e. number of objects (\emph{n}), number of latent
dimensions (\emph{p}), number of clusters (\emph{G}), and number of
subjects (\emph{S}).}

\item{model}{An object of class \code{\link{dmbc_model}}.}
}
\description{
Create an instance of the \code{dmbc_fit} class using new/initialize.
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
