% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-helpers.R
\name{check_key}
\alias{check_key}
\title{Check if column(s) can be used as keys}
\usage{
check_key(.data, ...)
}
\arguments{
\item{.data}{The data frame whose columns should be tested for key properties.}

\item{...}{The names of the columns to be checked.

One or more unquoted expressions separated by commas.
Variable names can be treated as if they were positions, so you
can use expressions like x:y to select ranges of variables.

The arguments in \code{...} are automatically quoted and evaluated in a context
where column names represent column positions.
They also support
unquoting and splicing.

See selection helpers for more details and examples about tidyselect helpers
such as \code{starts_with()}, \code{everything()}, etc.}
}
\value{
Returns \code{.data}, invisibly, if the check is passed.
Otherwise an error is thrown and the reason for it is explained.
}
\description{
\code{check_key()} accepts a data frame and, optionally, columns.
It throws an error
if the specified columns are NOT a unique key of the data frame.
If the columns given in the ellipsis ARE a key, the data frame itself is returned silently, so that it can be used for piping.
}
\examples{
data <- tibble::tibble(a = c(1, 2, 1), b = c(1, 4, 1), c = c(5, 6, 7))
# this is failing:
try(check_key(data, a, b))

# this is passing:
check_key(data, a, c)
}
