% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview.R
\name{plot.overview}
\alias{plot.overview}
\title{Visualize Information for an "overview" Object}
\usage{
\method{plot}{overview}(
  x,
  order_type = c("none", "name", "type"),
  typographic = TRUE,
  base_family = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "overview", usually, a result of a call to overview().}

\item{order_type}{character. method of order of bars(variables).}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{further arguments to be passed from or to other methods.}
}
\description{
Visualize a plot by attribute of `overview` class.
Visualize the data type, number of observations, and number of missing values for each variable.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
\donttest{
ov <- overview(jobchange)
ov

summary(ov)

plot(ov)

# sort by name of variables
plot(ov, order_type = "name")

# sort by data type of variables
# plot(ov, order_type = "type")
}

}
\seealso{
\code{\link{overview}}, \code{\link{summary.overview}}.
}
