% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{summary.univar_numeric}
\alias{summary.univar_numeric}
\alias{print.univar_numeric}
\title{Summarizing univar_numeric information}
\usage{
\method{summary}{univar_numeric}(object, stand = c("robust", "minmax", "zscore"), ...)

\method{print}{univar_numeric}(x, ...)
}
\arguments{
\item{object}{an object of class "univar_numeric", usually, a result of a call to univar_numeric().}

\item{stand}{character Describe how to standardize the original data. 
"robust" normalizes the raw data through transformation calculated by IQR and median.
"minmax" normalizes the original data using minmax transformation.
"zscore" standardizes the original data using z-Score transformation.
The default is "robust".}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "univar_numeric", usually, a result of a call to univar_numeric().}
}
\value{
An object of the class as indivisual variabes based list.
The statistics returned by summary.univar_numeric() are different from the statistics returned by univar_numeric().
univar_numeric() is the statistics for the original data, but summary. univar_numeric() is the statistics for the standardized data.
A component named "statistics" is a tibble object with the following statistics.:
\itemize{
\item variable : factor. The level of the variable. 'variable' is the name of the variable.
\item n : number of observations excluding missing values
\item na : number of missing values
\item mean : arithmetic average
\item sd : standard deviation
\item se_mean : standard error mean. sd/sqrt(n)
\item IQR : interquartile range (Q3-Q1)
\item skewness : skewness
\item kurtosis : kurtosis
\item median : median. 50\% percentile
}
}
\description{
print and summary method for "univar_numeric" class.
}
\details{
print.univar_numeric() displays only the information of variables included in univar_numeric 
The "variables" attribute is not displayed.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

library(dplyr)

# Calculates the all categorical variavels
all_var <- univar_numeric(carseats)

# Print univar_numeric class object
all_var

# Calculates the Price, CompPrice variable
univar_numeric(carseats, Price, CompPrice)
  
# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Summary by returned object
stat

# Statistics of numerical variables normalized by Min-Max method
summary(all_var, stand = "minmax")

# Statistics of numerical variables standardized by Z-score method
summary(all_var, stand = "zscore")

}
\seealso{
\code{\link{plot.univar_numeric}}.
}
