% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_by.R
\name{print.relate}
\alias{print.relate}
\title{Summarizing relate information}
\usage{
\method{print}{relate}(x, ...)
}
\arguments{
\item{x}{an object of class "relate", usually, a result of a call to relate().}

\item{...}{further arguments passed to or from other methods.}
}
\description{
print and summary method for "relate" class.
}
\details{
print.relate() tries to be smart about formatting four kinds of relate.
summary.relate() tries to be smart about formatting four kinds of relate.
}
\examples{
\dontrun{
# Generate data for the example
diamonds2 <- diamonds
diamonds2[sample(seq(NROW(diamonds2)), 250), "price"] <- NA
diamonds2[sample(seq(NROW(diamonds2)), 20), "clarity"] <- NA

# Binning the carat variable. default type argument is "quantile"
bin <- binning(diamonds2$carat)

# Print bins class object
bin

# Summarize bins class object
summary(bin)
}


# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# If the target variable is a categorical variable
categ <- target_by(carseats, US)

# If the variable of interest is a numerical variable
cat_num <- relate(categ, Sales)
cat_num
summary(cat_num)

# plot(cat_num)

# If the variable of interest is a categorical variable
cat_cat <- relate(categ, ShelveLoc)
cat_cat
summary(cat_cat)

# plot(cat_cat)

##---------------------------------------------------
# If the target variable is a categorical variable
num <- target_by(carseats, Sales)

# If the variable of interest is a numerical variable
num_num <- relate(num, Price)
num_num
summary(num_num)

# plot(num_num)

# If the variable of interest is a categorical variable
num_cat <- relate(num, ShelveLoc)
num_cat
summary(num_cat)

# plot(num_cat)

# Not allow typographic
# plot(num_cat, typographic = FALSE)

}
\seealso{
\code{\link{plot.relate}}.
}
