% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{summary.bins}
\alias{summary.bins}
\alias{print.bins}
\title{Summarizing Binned Variable}
\usage{
\method{summary}{bins}(object, ...)

\method{print}{bins}(x, ...)
}
\arguments{
\item{object}{an object of "bins" and "optimal_bins",
usually, a result of a call to binning().}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "bins" and "optimal_bins",
usually, a result of a call to binning().}
}
\value{
The function summary.bins() computes and returns a data.frame of summary statistics of the
binned given in object. Variables of data frame is as follows.
\itemize{
\item levels : levels of factor.
\item freq : frequency of levels.
\item rate : relative frequency of levels. it is not percentage.
}
}
\description{
summary method for "bins" and "optimal_bins".
}
\details{
print.bins() prints the information of "bins" and "optimal_bins" objects nicely.
This includes frequency of bins, binned type, and number of bins.
summary.bins() returns data.frame including frequency and relative frequency for each levels(bins).

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Binning the carat variable. default type argument is "quantile"
bin <- binning(carseats$Income)

# Print bins class object
bin

# Summarise bins class object
summary(bin)
}
\seealso{
\code{\link{binning}}
}
