% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dixonTest.R
\name{dixonTest}
\alias{dixonTest}
\title{Dixons Outlier Test (Q-Test)}
\usage{
dixonTest(x, alternative = c("two.sided", "greater", "less"),
  refined = FALSE)
}
\arguments{
\item{x}{a numeric vector of data}

\item{alternative}{the alternative hypothesis.
Defaults to \code{"two.sided"}}

\item{refined}{logical indicator, whether the refined version
or the Q-test shall be performed. Defaults to \code{FALSE}}
}
\description{
Performs Dixons single outlier test.
}
\details{
Let \eqn{X} denote an identically and independently distributed
normal variate. Further, let the increasingly ordered realizations
denote \eqn{x_1 \le x_2 \le \ldots \le x_n}.
Dixon (1950) proposed the following ratio statistic to detect
an outlier (two sided):

 \deqn{
  r_{j,i-1} = \max\left\{\frac{x_n - x_{n-j}}{x_n - x_i},
  \frac{x_{1+j} - x_1}{x_{n-i} - x_1}\right\}}{%
  r[j,i-1] = max\{(x[n] - x[n-j]) / (x[n] - x[i]),
             (x[1+j] - x[1]) / (x[n-i] - x[1])\}
  }

The null hypothesis, no outlier, is tested against the alternative,
at least one observation is an outlier (two sided). The subscript \eqn{j}
on the \eqn{r} symbol indicates the number of
outliers that are suspected at the upper end of the data set,
and the subscript \eqn{i} indicates the number of outliers suspected
at the lower end. For \eqn{r_{10}} it is also common to use the
statistic \eqn{Q}.

The statistic for a single maximum outlier is:
\deqn{
  r_{j,i-1} = \left(x_n - x_{n-j} \right) / \left(x_n - x_i\right)}{%
  r[j,i-1] = (x[n] - x[n-j]) / (x[n] - x[i])
  }
The null hypothesis is tested against the alternative,
the maximum observation is an outlier.


For testing a single minimum outlier, the test statistic is:
\deqn{
   r_{j,i-1} = \left(x_{1+j} - x_1 \right) / \left(x_{n-i} - x_1 \right)}{%
   r[j,i-1] = (x[1+j] - x[1]) / (x[n] - x[i])
   }

The null hypothesis is tested against the alternative,
the minimum observation is an outlier.

Apart from the earlier Dixons Q-test (i.e. \eqn{r_{10}}),
a refined version that was later proposed by Dixon can be performed
with this function, where the statistic \eqn{r_{j,i-1}} depends on
the sample size as follows:

\tabular{rl}{
 \eqn{r_{10}}: \tab \eqn{3 \le n \le 7} \cr
 \eqn{r_{11}}: \tab \eqn{8 \le n \le 10} \cr
 \eqn{r_{21}}; \tab \eqn{11 \le n \le 13} \cr
 \eqn{r_{22}}: \tab \eqn{14 \le n \le 30} \cr
}

The p-value is computed with the function \code{\link{pdixon}}.
}
\examples{
## example from Dean and Dixon 1951, Anal. Chem., 23, 636-639.
x <- c(40.02, 40.12, 40.16, 40.18, 40.18, 40.20)
dixonTest(x, alternative = "two.sided")

## example from the dataplot manual of NIST
x <- c(568, 570, 570, 570, 572, 578, 584, 596)
dixonTest(x, alternative = "greater", refined = TRUE)

}
\references{
Dixon, W. J. (1950) Analysis of extreme values.
\emph{Ann. Math. Stat.} \bold{21}, 488--506.
\url{http://dx.doi.org/10.1214/aoms/1177729747}.

Dean, R. B., Dixon, W. J. (1951) Simplified statistics for small
numbers of observation. \emph{Anal. Chem.} \bold{23}, 636--638.
\url{http://dx.doi.org/10.1021/ac60052a025}.

McBane, G. C. (2006) Programs to compute distribution functions
and critical values for extreme value ratios for outlier detection.
\emph{J. Stat. Soft.} \bold{16}. \url{http://dx.doi.org/10.18637/jss.v016.i03}.
}
\concept{outliers}
\keyword{htest}
