% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{read_data}
\alias{read_data}
\title{A procedure to read data of a data file in formats csv, dta or spss}
\usage{
read_data(path, type = "csv", sep = ",", category_row = FALSE)
}
\arguments{
\item{path}{A string representing the path to data file. If the data contained in the file is shaped as a matrix, the first column must include the names of the categories. If the data is shaped as edges list, it must contain three columns: Entity, category and value.}

\item{type}{It indicates the type of data to be read. This parameter facilitates the input of diverse types of data files, such as spss or stata. Possible options are the names of the mentioned software. The default value is csv.}

\item{sep}{Separator character used in the file to separate columns. Only for CSV file. Default value is comma.}

\item{category_row}{A flag to indicate that categories are in the rows. The analysis assumes that the categories are in the columns of the matrix. If the categories are in the rows and the entities in the columns, then the parameter "category_row" has to be set to TRUE. The default value is FALSE.}
}
\value{
A data frame with three columns (entity, category, value).
}
\description{
This function reads a file with data shaped as a matrix or as edges list. Several types of formats are allowed.
}
\examples{
#reading an edges list or panel shape, source data must include three columns
path <-   system.file("extdata", "PantheonEdges.csv", package = "diverse")
sep <- ","
data <- read_data(path)
#reading a table
path  <- system.file("extdata", "PantheonMatrix.csv", package = "diverse")
sep <- ","
data <- read_data(path)
#reading a table which includes the entities in the columns
path <- system.file("extdata", "Geese.csv", package = "diverse")
data <- read_data(path, category_row=TRUE)
}

