% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_divent.R
\name{phylo_divent}
\alias{phylo_divent}
\alias{as_phylo_divent}
\alias{is_phylo_divent}
\title{Class phylo_divent}
\usage{
as_phylo_divent(tree)

is_phylo_divent(x)
}
\arguments{
\item{tree}{An ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{x}{An object of class "phylo_divent".}
}
\value{
\code{as_phylo_divent} returns a phylogenetic tree that is an object of
class "phylo_divent".
}
\description{
Methods for dendrograms of class "phylo_divent".
}
\details{
\code{as_phylo_divent} calculates cuts and intervals of a phylogenetic tree and makes
it available both in \link[stats:hclust]{stats::hclust} and \link[ape:read.tree]{ape::phylo} formats.
The conversion preprocesses the tree: it calculates cuts so that the tree
can be reused efficiently by phylodiversity functions.
}
\examples{
# Paracou plot 6 species taxonomy
tree <- as_phylo_divent(mock_3sp_tree)
plot(tree)

}
