% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binomial.R
\name{cdf.Binomial}
\alias{cdf.Binomial}
\title{Evaluate the cumulative distribution function of a Binomial distribution}
\usage{
\method{cdf}{Binomial}(d, x, ...)
}
\arguments{
\item{d}{A \code{Binomial} object created by a call to \code{\link[=Binomial]{Binomial()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a Binomial distribution
}
\examples{

set.seed(27)

X <- Binomial(10, 0.2)
X

random(X, 10)

pdf(X, 2L)
log_pdf(X, 2L)

cdf(X, 4L)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
