require(distrMod)
options("newDevice"=TRUE)

## example to CvM MDE for Normal Location and Scale

x <- rnorm(30)
NF <- NormLocationScaleFamily()

system.time(print(MDEstimator(x,NF,CvMDist)))

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = NF, distance = CvMDist)
#samplesize:   30
#estimate:
#      mean         sd
#0.08533113 1.40693795
#Criterion:
#CvM distance
#  0.04340385
#   user  system elapsed
#   1.94    0.00    1.94

#with useApply
system.time(print(MDEstimator(x,NF,CvMDist,useApply=TRUE)))

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = NF, distance = CvMDist, useApply = TRUE)
#samplesize:   30
#estimate:
#      mean         sd
#0.08533113 1.40693795
#Criterion:
#CvM distance
#  0.04340385
#   user  system elapsed
#  12.12    0.01   12.19


MDEstimator(rnorm(30),NF,CvMDist)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = rnorm(30), ParamFamily = NF, distance = CvMDist)
#samplesize:   30
#estimate:
#      mean         sd
#0.03446453 1.03476194
#Criterion:
#CvM distance
#  0.03514274

#another sample
MDEstimator(rnorm(30),NF,CvMDist)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = rnorm(30), ParamFamily = NF, distance = CvMDist)
#samplesize:   30
#estimate:
#       mean          sd
#-0.06154767  1.20988270
#Criterion:
#CvM distance
#  0.03146225


# larger sample size
MDEstimator(rnorm(300),NF,CvMDist)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = rnorm(300), ParamFamily = NF, distance = CvMDist)
#samplesize:   300
#estimate:
#       mean          sd
#-0.08629963  1.03697176
#Criterion:
#CvM distance
# 0.009871934

MDEstimator(rnorm(300,mean=2,sd=2),NF,CvMDist)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = rnorm(300, mean = 2, sd = 2), ParamFamily = NF,
#    distance = CvMDist)
#samplesize:   300
#estimate:
#    mean       sd
#2.164488 1.952065
#Criterion:
#CvM distance
#  0.01002004


#another sample
MDEstimator(rnorm(300,mean=2,sd=2),NF,CvMDist)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = rnorm(300, mean = 2, sd = 2), ParamFamily = NF,
#    distance = CvMDist)
#samplesize:   300
#estimate:
#    mean       sd
#1.877466 1.990109
#Criterion:
#CvM distance
# 0.009298052
